/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete.functions.memory;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import org.jamocha.rete.BaseJoin;
import org.jamocha.rete.Constants;
import org.jamocha.rete.DefaultReturnVector;
import org.jamocha.rete.DefaultWM;
import org.jamocha.rete.ExistJoin;
import org.jamocha.rete.Fact;
import org.jamocha.rete.Function;
import org.jamocha.rete.HashedAlphaMemoryImpl;
import org.jamocha.rete.HashedEqBNode;
import org.jamocha.rete.HashedEqNJoin;
import org.jamocha.rete.HashedNeqAlphaMemory;
import org.jamocha.rete.HashedNotEqBNode;
import org.jamocha.rete.HashedNotEqNJoin;
import org.jamocha.rete.NotJoin;
import org.jamocha.rete.Parameter;
import org.jamocha.rete.Rete;
import org.jamocha.rete.ReturnVector;
import org.jamocha.rete.ZJBetaNode;
import org.jamocha.rete.functions.BaseMatchFunction;

public class RightMatchesFunction
extends BaseMatchFunction
implements Function,
Serializable {
    public static final String RIGHT_MATCHES = "right-matches";

    public int getReturnType() {
        return 12;
    }

    public ReturnVector executeFunction(Rete engine, Parameter[] params) {
        this.printRightMatches(engine);
        return new DefaultReturnVector();
    }

    protected void printRightMatches(Rete engine) {
        DefaultWM wm = (DefaultWM)engine.getWorkingMemory();
        ArrayList betaNodes = this.getSortedBetaNodes(wm);
        int idx = 0;
        while (idx < betaNodes.size()) {
            BaseJoin join = (BaseJoin)betaNodes.get(idx);
            if (!(join instanceof ZJBetaNode)) {
                this.printBetaNodeDetailInfo(join, engine, wm);
            }
            ++idx;
        }
    }

    public void printBetaNodeDetailInfo(BaseJoin betaNode, Rete engine, DefaultWM wm) {
        StringBuffer buf = new StringBuffer();
        buf.append(betaNode.toPPString());
        Map lmem = (Map)wm.getBetaLeftMemory(betaNode);
        Object rmem = wm.getBetaRightMemory(betaNode);
        buf.append(" - right memories:" + Constants.LINEBREAK);
        if (betaNode instanceof HashedEqBNode || betaNode instanceof HashedEqNJoin) {
            HashedAlphaMemoryImpl haMem = (HashedAlphaMemoryImpl)rmem;
            Object[] facts = haMem.iterateAll();
            int idx = 0;
            while (idx < facts.length) {
                Fact f = (Fact)facts[idx];
                buf.append("\t" + f.toFactString() + Constants.LINEBREAK);
                ++idx;
            }
        } else if (betaNode instanceof HashedNotEqNJoin || betaNode instanceof HashedNotEqBNode) {
            HashedNeqAlphaMemory haneqMem = (HashedNeqAlphaMemory)rmem;
            Object[] facts = haneqMem.iterateAll();
            int idx = 0;
            while (idx < facts.length) {
                Fact f = (Fact)facts[idx];
                buf.append("\t" + f.toFactString() + Constants.LINEBREAK);
                ++idx;
            }
        } else if (betaNode instanceof ExistJoin || betaNode instanceof NotJoin) {
            Map rmMem = (Map)rmem;
            for (Fact f : rmMem.keySet()) {
                buf.append("\t" + f.toFactString() + Constants.LINEBREAK);
            }
        }
        buf.append(Constants.LINEBREAK);
        engine.writeMessage(buf.toString());
    }

    public String getName() {
        return RIGHT_MATCHES;
    }

    public Class[] getParameter() {
        return new Class[0];
    }

    public String toPPString(Parameter[] params, int indents) {
        return "(right-matches)\nFunction description:\n\tPrints out the facts in the right side of BetaNodes,\n\tand does not show which facts it matches on the left.";
    }
}

