/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete.functions.memory;

import java.io.Serializable;
import org.jamocha.rete.Constants;
import org.jamocha.rete.DefaultReturnVector;
import org.jamocha.rete.Function;
import org.jamocha.rete.Parameter;
import org.jamocha.rete.Rete;
import org.jamocha.rete.ReturnVector;

public class MemoryUsedFunction
implements Function,
Serializable {
    public static final String MEMORY_FREE = "mem-used";

    public int getReturnType() {
        return 12;
    }

    public ReturnVector executeFunction(Rete engine, Parameter[] params) {
        Runtime rt = Runtime.getRuntime();
        long free = rt.freeMemory();
        long total = rt.totalMemory();
        long used = total - free;
        used = used / 1024L / 1024L;
        long mbtotal = (total /= 1024L) / 1024L;
        engine.writeMessage(String.valueOf(String.valueOf(used)) + "Mb used of " + String.valueOf(mbtotal) + "Mb " + Constants.LINEBREAK, "t");
        DefaultReturnVector ret = new DefaultReturnVector();
        return ret;
    }

    public String getName() {
        return MEMORY_FREE;
    }

    public Class[] getParameter() {
        return new Class[0];
    }

    public String toPPString(Parameter[] params, int indents) {
        return "(mem-free)";
    }
}

