/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete.functions.memory;

import java.io.Serializable;
import org.jamocha.rete.Constants;
import org.jamocha.rete.DefaultReturnVector;
import org.jamocha.rete.Function;
import org.jamocha.rete.Parameter;
import org.jamocha.rete.Rete;
import org.jamocha.rete.ReturnVector;

public class MemoryTotalFunction
implements Function,
Serializable {
    public static final String MEMORY_TOTAL = "mem-total";

    public int getReturnType() {
        return 12;
    }

    public ReturnVector executeFunction(Rete engine, Parameter[] params) {
        Runtime rt = Runtime.getRuntime();
        long total = rt.totalMemory();
        engine.writeMessage("Total memory " + String.valueOf(total / 1024L) + "Kb | " + String.valueOf(total / 1024L / 1024L) + "Mb" + Constants.LINEBREAK, "t");
        DefaultReturnVector ret = new DefaultReturnVector();
        return ret;
    }

    public String getName() {
        return MEMORY_TOTAL;
    }

    public Class[] getParameter() {
        return new Class[0];
    }

    public String toPPString(Parameter[] params, int indents) {
        return "(mem-total)";
    }
}

