/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete.functions.memory;

import java.io.Serializable;
import org.jamocha.rete.Constants;
import org.jamocha.rete.DefaultReturnVector;
import org.jamocha.rete.Function;
import org.jamocha.rete.Parameter;
import org.jamocha.rete.Rete;
import org.jamocha.rete.ReturnVector;

public class MemoryFreeFunction
implements Function,
Serializable {
    public static final String MEMORY_FREE = "mem-free";

    public int getReturnType() {
        return 12;
    }

    public ReturnVector executeFunction(Rete engine, Parameter[] params) {
        Runtime rt = Runtime.getRuntime();
        long free = rt.freeMemory();
        long total = rt.totalMemory();
        double percentfree = (double)free / (double)total * 100.0;
        long mbtotal = (total /= 1024L) / 1024L;
        String freestr = String.valueOf(percentfree).substring(0, 4);
        engine.writeMessage(String.valueOf(String.valueOf(free /= 1024L)) + "Kb - " + freestr + "% free of " + String.valueOf(mbtotal) + "Mb / " + String.valueOf(total) + "Kb " + Constants.LINEBREAK, "t");
        DefaultReturnVector ret = new DefaultReturnVector();
        return ret;
    }

    public String getName() {
        return MEMORY_FREE;
    }

    public Class[] getParameter() {
        return new Class[0];
    }

    public String toPPString(Parameter[] params, int indents) {
        return "(mem-free)";
    }
}

