/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete.functions.memory;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jamocha.rete.AlphaMemory;
import org.jamocha.rete.BaseAlpha;
import org.jamocha.rete.BaseJoin;
import org.jamocha.rete.BoundParam;
import org.jamocha.rete.Constants;
import org.jamocha.rete.DefaultReturnVector;
import org.jamocha.rete.DefaultWM;
import org.jamocha.rete.ExistJoin;
import org.jamocha.rete.Function;
import org.jamocha.rete.HashedAlphaMemoryImpl;
import org.jamocha.rete.HashedEqBNode;
import org.jamocha.rete.HashedEqNJoin;
import org.jamocha.rete.HashedNeqAlphaMemory;
import org.jamocha.rete.HashedNotEqBNode;
import org.jamocha.rete.HashedNotEqNJoin;
import org.jamocha.rete.IFLIANode;
import org.jamocha.rete.LIANode;
import org.jamocha.rete.NotJoin;
import org.jamocha.rete.ObjectTypeNode;
import org.jamocha.rete.Parameter;
import org.jamocha.rete.Rete;
import org.jamocha.rete.ReturnVector;
import org.jamocha.rete.ValueParam;
import org.jamocha.rete.functions.BaseMatchFunction;

public class MatchesFunction
extends BaseMatchFunction
implements Function,
Serializable {
    public static final String MATCHES = "matches";

    public int getReturnType() {
        return 12;
    }

    public ReturnVector executeFunction(Rete engine, Parameter[] params) {
        HashMap<String, Object> filter = new HashMap<String, Object>();
        if (params != null && params.length > 0) {
            int idx = 0;
            while (idx < params.length) {
                if (params[idx] instanceof ValueParam) {
                    filter.put(((ValueParam)params[idx]).getStringValue(), null);
                } else {
                    boolean cfr_ignored_0 = params[idx] instanceof BoundParam;
                }
                ++idx;
            }
        }
        this.printMemoriesByNodes(engine, filter);
        return new DefaultReturnVector();
    }

    protected void printMemoriesByNodes(Rete engine, HashMap filter) {
        DefaultWM wm = (DefaultWM)engine.getWorkingMemory();
        ArrayList alphaNodes = this.getSortedAlphaNodes(wm);
        int idx = 0;
        while (idx < alphaNodes.size()) {
            this.printAlphaNodeInfo((BaseAlpha)alphaNodes.get(idx), engine, wm);
            ++idx;
        }
        ArrayList betaNodes = this.getSortedBetaNodes(wm);
        int idx2 = 0;
        while (idx2 < betaNodes.size()) {
            this.printBetaNodeInfo((BaseJoin)betaNodes.get(idx2), engine, wm);
            ++idx2;
        }
    }

    protected void printMemoryForRule(Rete engine, HashMap filter) {
    }

    protected void printAlphaNodeInfo(BaseAlpha alphaNode, Rete engine, DefaultWM wm) {
        if (!(alphaNode instanceof ObjectTypeNode || alphaNode instanceof LIANode || alphaNode instanceof IFLIANode)) {
            StringBuffer buf = new StringBuffer();
            buf.append(alphaNode.toPPString());
            AlphaMemory alphaMem = (AlphaMemory)wm.getAlphaMemory(alphaNode);
            buf.append(" - Total Memories: " + alphaMem.size());
            buf.append(Constants.LINEBREAK);
            engine.writeMessage(buf.toString());
        }
    }

    protected void printBetaNodeInfo(BaseJoin betaNode, Rete engine, DefaultWM wm) {
        StringBuffer buf = new StringBuffer();
        buf.append(betaNode.toPPString());
        Map lmem = (Map)wm.getBetaLeftMemory(betaNode);
        Object rmem = wm.getBetaRightMemory(betaNode);
        buf.append(" - left memory count:" + lmem.size());
        if (betaNode instanceof HashedEqBNode || betaNode instanceof HashedEqNJoin) {
            HashedAlphaMemoryImpl haMem = (HashedAlphaMemoryImpl)rmem;
            buf.append(" / right memory count:" + haMem.size());
        } else if (betaNode instanceof HashedNotEqNJoin || betaNode instanceof HashedNotEqBNode) {
            HashedNeqAlphaMemory haneqMem = (HashedNeqAlphaMemory)rmem;
            buf.append(" / right memory count:" + haneqMem.size());
        } else if (betaNode instanceof ExistJoin || betaNode instanceof NotJoin) {
            Map rmMem = (Map)rmem;
            buf.append(" / right memory count:" + rmMem.size());
        }
        buf.append(Constants.LINEBREAK);
        engine.writeMessage(buf.toString());
    }

    public String getName() {
        return MATCHES;
    }

    public Class[] getParameter() {
        return new Class[]{String[].class};
    }

    public String toPPString(Parameter[] params, int indents) {
        return "(matches)\nFunction description:\n\tPrints out a summary of the facts for each node.";
    }
}

