/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete.functions.math;

import java.io.Serializable;
import java.math.BigDecimal;
import org.jamocha.rete.BoundParam;
import org.jamocha.rete.DefaultReturnValue;
import org.jamocha.rete.DefaultReturnVector;
import org.jamocha.rete.Function;
import org.jamocha.rete.Parameter;
import org.jamocha.rete.Rete;
import org.jamocha.rete.ReturnVector;
import org.jamocha.rete.ValueParam;

public class Tanh
implements Function,
Serializable {
    public static final String TANH = "tanh";

    public int getReturnType() {
        return 5;
    }

    public ReturnVector executeFunction(Rete engine, Parameter[] params) {
        double dval = 0.0;
        if (params != null && params.length == 1) {
            if (params[0] instanceof ValueParam) {
                ValueParam n = (ValueParam)params[0];
                dval = n.getDoubleValue();
            } else {
                dval = new BigDecimal(params[0].getValue(engine, 22).toString()).doubleValue();
            }
            dval = Math.tanh(dval);
        }
        DefaultReturnVector ret = new DefaultReturnVector();
        DefaultReturnValue rv = new DefaultReturnValue(5, dval);
        ret.addReturnValue(rv);
        return ret;
    }

    public String getName() {
        return TANH;
    }

    public Class[] getParameter() {
        return new Class[]{ValueParam[].class};
    }

    public String toPPString(Parameter[] params, int indents) {
        if (params != null && params.length >= 0) {
            StringBuffer buf = new StringBuffer();
            buf.append("(tanh");
            int idx = 0;
            if (params[idx] instanceof BoundParam) {
                BoundParam bp = (BoundParam)params[idx];
                buf.append(" ?" + bp.getVariableName());
            } else if (params[idx] instanceof ValueParam) {
                buf.append(" " + params[idx].getStringValue());
            } else {
                buf.append(" " + params[idx].getStringValue());
            }
            buf.append(")");
            return buf.toString();
        }
        return "(tanh <literal> | <binding>)\nFunction description:\n\tCalculates the tangent of the numeric argument.\n\tThe argument is expected to be in radians.";
    }
}

