/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete.functions.math;

import java.io.Serializable;
import java.math.BigDecimal;
import org.jamocha.rete.BoundParam;
import org.jamocha.rete.DefaultReturnValue;
import org.jamocha.rete.DefaultReturnVector;
import org.jamocha.rete.Function;
import org.jamocha.rete.Parameter;
import org.jamocha.rete.Rete;
import org.jamocha.rete.ReturnVector;
import org.jamocha.rete.ValueParam;

public class Max
implements Function,
Serializable {
    public static final String MAX = "max";

    public int getReturnType() {
        return 22;
    }

    public ReturnVector executeFunction(Rete engine, Parameter[] params) {
        BigDecimal bdval = new BigDecimal(0);
        BigDecimal bd = new BigDecimal(0);
        if (params != null) {
            int idx = 0;
            while (idx < params.length) {
                if (params[idx] instanceof ValueParam) {
                    ValueParam n = (ValueParam)params[idx];
                    bd = n.getBigDecimalValue();
                } else {
                    bd = new BigDecimal(params[idx].getValue(engine, 22).toString());
                }
                bdval = idx == 0 ? bdval.add(bd) : bdval.max(bd);
                ++idx;
            }
        }
        DefaultReturnVector ret = new DefaultReturnVector();
        DefaultReturnValue rv = new DefaultReturnValue(22, bdval);
        ret.addReturnValue(rv);
        return ret;
    }

    public String getName() {
        return MAX;
    }

    public Class[] getParameter() {
        return new Class[]{ValueParam[].class};
    }

    public String toPPString(Parameter[] params, int indents) {
        if (params != null && params.length >= 0) {
            StringBuffer buf = new StringBuffer();
            buf.append("(max");
            int idx = 0;
            if (params[idx] instanceof BoundParam) {
                BoundParam bp = (BoundParam)params[idx];
                buf.append(" ?" + bp.getVariableName());
            } else if (params[idx] instanceof ValueParam) {
                buf.append(" " + params[idx].getStringValue());
            } else {
                buf.append(" " + params[idx].getStringValue());
            }
            buf.append(")");
            return buf.toString();
        }
        return "(max (<literal> | <binding>)+)\nFunction description:\n\tReturns the value of its largest numeric argument.";
    }
}

