/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete.functions.math;

import java.io.Serializable;
import java.math.BigDecimal;
import org.jamocha.rete.BoundParam;
import org.jamocha.rete.DefaultReturnValue;
import org.jamocha.rete.DefaultReturnVector;
import org.jamocha.rete.Function;
import org.jamocha.rete.Parameter;
import org.jamocha.rete.Rete;
import org.jamocha.rete.ReturnVector;
import org.jamocha.rete.ValueParam;

public class Log10
implements Function,
Serializable {
    public static final String LOG10 = "log10";

    public int getReturnType() {
        return 22;
    }

    public ReturnVector executeFunction(Rete engine, Parameter[] params) {
        BigDecimal bdval = new BigDecimal(0);
        if (params.length == 1) {
            if (params[0] instanceof ValueParam) {
                ValueParam n = (ValueParam)params[0];
                bdval = n.getBigDecimalValue();
            } else {
                bdval = new BigDecimal(params[0].getValue(engine, 22).toString());
            }
            double bdh = Math.log10(bdval.doubleValue());
            bdval = BigDecimal.valueOf(bdh);
        }
        DefaultReturnVector ret = new DefaultReturnVector();
        DefaultReturnValue rv = new DefaultReturnValue(22, bdval);
        ret.addReturnValue(rv);
        return ret;
    }

    public String getName() {
        return LOG10;
    }

    public Class[] getParameter() {
        return new Class[]{ValueParam[].class};
    }

    public String toPPString(Parameter[] params, int indents) {
        if (params != null && params.length >= 0) {
            StringBuffer buf = new StringBuffer();
            buf.append("(log10");
            int idx = 0;
            if (params[idx] instanceof BoundParam) {
                BoundParam bp = (BoundParam)params[idx];
                buf.append(" ?" + bp.getVariableName());
            } else if (params[idx] instanceof ValueParam) {
                buf.append(" " + params[idx].getStringValue());
            } else {
                buf.append(" " + params[idx].getStringValue());
            }
            buf.append(")");
            return buf.toString();
        }
        return "(log10 <expression>)\nFunction description:\n\tCalculates the logarithm of its argument to the base 10.";
    }
}

