/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete.functions.math;

import java.io.Serializable;
import java.math.BigDecimal;
import org.jamocha.rete.BoundParam;
import org.jamocha.rete.DefaultReturnValue;
import org.jamocha.rete.DefaultReturnVector;
import org.jamocha.rete.Function;
import org.jamocha.rete.Parameter;
import org.jamocha.rete.Rete;
import org.jamocha.rete.ReturnVector;
import org.jamocha.rete.ValueParam;

public class LessOrEqual
implements Function,
Serializable {
    public static final String LESSOREQUAL = "lessOrEqual";

    public int getReturnType() {
        return 20;
    }

    public ReturnVector executeFunction(Rete engine, Parameter[] params) {
        boolean eval = false;
        BigDecimal left = null;
        BigDecimal right = null;
        if (params != null) {
            left = params[0] instanceof ValueParam ? params[0].getBigDecimalValue() : new BigDecimal(params[0].getValue(engine, 22).toString());
            int idx = 1;
            while (idx < params.length) {
                right = params[idx] instanceof ValueParam ? params[idx].getBigDecimalValue() : new BigDecimal(params[idx].getValue(engine, 22).toString());
                boolean bl = eval = left.doubleValue() <= right.doubleValue();
                if (!eval) break;
                left = right;
                ++idx;
            }
        }
        DefaultReturnVector ret = new DefaultReturnVector();
        DefaultReturnValue rv = new DefaultReturnValue(20, new Boolean(eval));
        ret.addReturnValue(rv);
        return ret;
    }

    public String getName() {
        return LESSOREQUAL;
    }

    public Class[] getParameter() {
        return new Class[]{ValueParam.class, ValueParam.class};
    }

    public String toPPString(Parameter[] params, int indents) {
        if (params != null && params.length > 0) {
            StringBuffer buf = new StringBuffer();
            buf.append("(<=");
            int idx = 0;
            while (idx < params.length) {
                if (params[idx] instanceof BoundParam) {
                    BoundParam bp = (BoundParam)params[idx];
                    buf.append(" ?" + bp.getVariableName());
                } else if (params[idx] instanceof ValueParam) {
                    buf.append(" " + params[idx].getStringValue());
                } else {
                    buf.append(" " + params[idx].getStringValue());
                }
                ++idx;
            }
            buf.append(")");
            return buf.toString();
        }
        return "(<= (<literal> | <binding>)+)\nFunction description:\n\t Returns the symbol TRUE if for all its arguments, argument \n \t n-1 is less or equal than argument n";
    }
}

