/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete.functions.math;

import java.io.Serializable;
import java.math.BigDecimal;
import org.jamocha.rete.BoundParam;
import org.jamocha.rete.DefaultReturnValue;
import org.jamocha.rete.DefaultReturnVector;
import org.jamocha.rete.Function;
import org.jamocha.rete.Parameter;
import org.jamocha.rete.Rete;
import org.jamocha.rete.ReturnVector;
import org.jamocha.rete.ValueParam;

public class Divide
implements Function,
Serializable {
    public static final String DIVIDE = "divide";

    public int getReturnType() {
        return 22;
    }

    public ReturnVector executeFunction(Rete engine, Parameter[] params) {
        BigDecimal bdval = null;
        if (params != null) {
            bdval = params[0] instanceof ValueParam ? params[0].getBigDecimalValue() : new BigDecimal(params[0].getValue(engine, 22).toString());
            int idx = 1;
            while (idx < params.length) {
                if (params[idx] instanceof ValueParam) {
                    ValueParam n = (ValueParam)params[idx];
                    BigDecimal bd = n.getBigDecimalValue();
                    bdval = bdval.divide(bd, 20, 1);
                } else {
                    BigDecimal bd = new BigDecimal(params[idx].getValue(engine, 22).toString());
                    bdval = bdval.divide(bd, 20, 1);
                }
                ++idx;
            }
        }
        DefaultReturnVector ret = new DefaultReturnVector();
        DefaultReturnValue rv = new DefaultReturnValue(5, bdval);
        ret.addReturnValue(rv);
        return ret;
    }

    public String getName() {
        return DIVIDE;
    }

    public Class[] getParameter() {
        return new Class[]{ValueParam[].class};
    }

    public String toPPString(Parameter[] params, int indents) {
        if (params != null && params.length > 0) {
            StringBuffer buf = new StringBuffer();
            buf.append("(/");
            int idx = 0;
            while (idx < params.length) {
                if (params[idx] instanceof BoundParam) {
                    BoundParam bp = (BoundParam)params[idx];
                    buf.append(" ?" + bp.getVariableName());
                } else if (params[idx] instanceof ValueParam) {
                    buf.append(" " + params[idx].getStringValue());
                } else {
                    buf.append(" " + params[idx].getStringValue());
                }
                ++idx;
            }
            buf.append(")");
            return buf.toString();
        }
        return "(/ (<literal> | <binding>)+)\nFunction description:\n\t Returns the value of the first argument divided by each of the subsequent arguments.";
    }

    private BigDecimal secureDivide(BigDecimal dividend, BigDecimal divisor) {
        try {
            dividend = dividend.divide(divisor);
        }
        catch (ArithmeticException e) {
            dividend = new BigDecimal(dividend.doubleValue() / divisor.doubleValue());
        }
        return dividend;
    }
}

