/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete.functions.macro;

import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.jamocha.logging.LogFactory;
import org.jamocha.logging.Logger;
import org.jamocha.rete.Constants;
import org.jamocha.rete.Defclass;
import org.jamocha.rete.Module;

public class MacroGenerator {
    protected Logger log = LogFactory.createLogger(MacroGenerator.class);
    protected int tabs = 0;
    public static final String READ_PREFIX = "Read";
    public static final String WRITE_PREFIX = "Write";
    public static final String JAVA_FILE_EXT = ".java";

    public void generateMacros(Defclass defclass, Module defmodule) {
        String packagename = defclass.getClassObject().getName().toLowerCase();
        PropertyDescriptor[] properties = defclass.getPropertyDescriptors();
        int idx = 0;
        while (idx < properties.length) {
            PropertyDescriptor prop = properties[idx];
            String formattedClassname = this.formatClassname(prop.getName());
            StringBuffer readbuf = new StringBuffer();
            StringBuffer writebuf = new StringBuffer();
            String basePath = String.valueOf(defmodule.getWorkingDirectory()) + "/" + packagename.replace('.', '/') + "/";
            String readClass = String.valueOf(basePath) + READ_PREFIX + formattedClassname + JAVA_FILE_EXT;
            String writeClass = String.valueOf(basePath) + WRITE_PREFIX + formattedClassname + JAVA_FILE_EXT;
            File baseDir = new File(basePath);
            baseDir.mkdirs();
            this.generateReadMacro(readbuf, prop, packagename, formattedClassname, defclass.getClassObject().getName());
            this.generateWriteMacro(writebuf, prop, packagename, formattedClassname, defclass.getClassObject().getName());
            this.writeClass(readbuf, readClass);
            this.writeClass(writebuf, writeClass);
            ++idx;
        }
    }

    public void generateReadMacro(StringBuffer buf, PropertyDescriptor property, String packageName, String className, String castClassName) {
        String readName = READ_PREFIX + className;
        this.writeTabs(buf);
        buf.append("package " + packageName + ";" + Constants.LINEBREAK);
        buf.append(Constants.LINEBREAK);
        this.writeTabs(buf);
        buf.append("import org.jamocha.rete.macro.ReadMacro;" + Constants.LINEBREAK);
        buf.append(Constants.LINEBREAK);
        this.writeTabs(buf);
        buf.append("public class " + readName + " implements ReadMacro {" + Constants.LINEBREAK);
        this.pushTab();
        this.writeTabs(buf);
        buf.append("public " + readName + "() {}" + Constants.LINEBREAK);
        buf.append(Constants.LINEBREAK);
        this.generateReadMethod(buf, castClassName, className);
        this.popTab();
        this.writeTabs(buf);
        buf.append("}" + Constants.LINEBREAK);
    }

    public void generateReadMethod(StringBuffer buf, String castClassName, String propertyName) {
        this.writeTabs(buf);
        buf.append("public Object getProperty(Object instance) {" + Constants.LINEBREAK);
        this.pushTab();
        this.writeTabs(buf);
        buf.append("return ((" + castClassName + ")instance).get" + propertyName + "();" + Constants.LINEBREAK);
        this.popTab();
        this.writeTabs(buf);
        buf.append("}" + Constants.LINEBREAK);
    }

    public void generateWriteMacro(StringBuffer buf, PropertyDescriptor property, String packageName, String className, String castClassName) {
        String writeName = WRITE_PREFIX + className;
        this.writeTabs(buf);
        buf.append("package " + packageName + ";" + Constants.LINEBREAK);
        buf.append(Constants.LINEBREAK);
        this.writeTabs(buf);
        buf.append("import org.jamocha.rete.macro.WriteMacro;" + Constants.LINEBREAK);
        buf.append(Constants.LINEBREAK);
        this.writeTabs(buf);
        buf.append("public class " + writeName + " implements WriteMacro {" + Constants.LINEBREAK);
        this.pushTab();
        this.writeTabs(buf);
        buf.append("public " + writeName + "() {}" + Constants.LINEBREAK);
        buf.append(Constants.LINEBREAK);
        this.generateWriteMethod(buf, castClassName, className, property.getReadMethod().getReturnType());
        this.popTab();
        this.writeTabs(buf);
        buf.append("}" + Constants.LINEBREAK);
    }

    public void generateWriteMethod(StringBuffer buf, String castClassName, String propertyName, Class propertyType) {
        this.writeTabs(buf);
        buf.append("public void setProperty(Object instance, Object value) {" + Constants.LINEBREAK);
        this.pushTab();
        this.writeTabs(buf);
        buf.append("((" + castClassName + ")instance).set" + propertyName + "(");
        buf.append("(" + this.formattedPropertyType(propertyType) + ")value");
        buf.append(");" + Constants.LINEBREAK);
        this.popTab();
        this.writeTabs(buf);
        buf.append("}" + Constants.LINEBREAK);
    }

    protected String formattedPropertyType(Class propertyType) {
        if (propertyType.getName() == "int") {
            return "Integer";
        }
        if (propertyType.getName() == "short") {
            return "Short";
        }
        if (propertyType.getName() == "float") {
            return "Float";
        }
        if (propertyType.getName() == "long") {
            return "Long";
        }
        if (propertyType.getName() == "double") {
            return "Double";
        }
        if (propertyType.getName() == "boolean") {
            return "Boolean";
        }
        return propertyType.getName();
    }

    public void writeTabs(StringBuffer buf) {
        int idx = 0;
        while (idx < this.tabs) {
            buf.append("    ");
            ++idx;
        }
    }

    public void pushTab() {
        ++this.tabs;
    }

    public void popTab() {
        --this.tabs;
    }

    public String formatClassname(String propertyName) {
        return String.valueOf(propertyName.substring(0, 1).toUpperCase()) + propertyName.substring(1);
    }

    public boolean writeClass(StringBuffer buf, String filename) {
        try {
            FileWriter writer = new FileWriter(filename);
            writer.write(buf.toString());
            writer.close();
        }
        catch (IOException e) {
            this.log.fatal(e);
        }
        return true;
    }
}

