/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete.functions.java;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.jamocha.rete.AbstractParam;
import org.jamocha.rete.BoundParam;
import org.jamocha.rete.DefaultReturnValue;
import org.jamocha.rete.DefaultReturnVector;
import org.jamocha.rete.Function;
import org.jamocha.rete.FunctionParam2;
import org.jamocha.rete.Parameter;
import org.jamocha.rete.Rete;
import org.jamocha.rete.ReturnVector;
import org.jamocha.rete.ValueParam;
import org.jamocha.rete.functions.java.ClassnameResolver;

public class NewFunction
implements Function,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String NEW = "new";
    private ClassnameResolver classnameResolver;

    public NewFunction(ClassnameResolver classnameResolver) {
        this.classnameResolver = classnameResolver;
    }

    public ReturnVector executeFunction(Rete engine, Parameter[] params) {
        Object o = null;
        String classname = null;
        Object[] args = null;
        if (params != null) {
            AbstractParam n;
            if (params[0] instanceof ValueParam) {
                n = (ValueParam)params[0];
                classname = n.getStringValue();
            } else if (params[0] instanceof BoundParam) {
                BoundParam bp = (BoundParam)params[0];
                classname = (String)engine.getBinding(bp.getVariableName());
            } else if (params[0] instanceof FunctionParam2) {
                n = (FunctionParam2)params[0];
                ((FunctionParam2)n).setEngine(engine);
                ((FunctionParam2)n).lookUpFunction();
                ReturnVector rval = (ReturnVector)((FunctionParam2)n).getValue();
                classname = rval.firstReturnValue().getStringValue();
            }
            args = new Object[params.length - 1];
            int idx = 1;
            while (idx < params.length) {
                AbstractParam n2;
                if (params[idx] instanceof ValueParam) {
                    n2 = (ValueParam)params[idx];
                    args[idx - 1] = ((ValueParam)n2).getValue();
                } else if (params[idx] instanceof BoundParam) {
                    BoundParam bp = (BoundParam)params[idx];
                    args[idx - 1] = engine.getBinding(bp.getVariableName());
                } else if (params[idx] instanceof FunctionParam2) {
                    n2 = (FunctionParam2)params[idx];
                    ((FunctionParam2)n2).setEngine(engine);
                    ((FunctionParam2)n2).lookUpFunction();
                    ReturnVector rval = (ReturnVector)((FunctionParam2)n2).getValue();
                    args[idx - 1] = rval.firstReturnValue().getValue();
                }
                ++idx;
            }
            try {
                Class<?> classDefinition = this.classnameResolver.resolveClass(classname);
                Constructor<?> foundConstructor = null;
                Constructor<?>[] constructorArray = classDefinition.getConstructors();
                int n3 = constructorArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    Constructor<?> constructor = constructorArray[n4];
                    Class<?>[] parameterClasses = constructor.getParameterTypes();
                    if (parameterClasses.length == args.length) {
                        boolean match = true;
                        int i = 0;
                        while (i < parameterClasses.length) {
                            match &= parameterClasses[i].isInstance(args[i]) || args[i] == null;
                            ++i;
                        }
                        if (match) {
                            foundConstructor = constructor;
                            break;
                        }
                    }
                    ++n4;
                }
                if (foundConstructor != null) {
                    o = foundConstructor.newInstance(args);
                }
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        DefaultReturnVector ret = new DefaultReturnVector();
        DefaultReturnValue rv = new DefaultReturnValue(9, o);
        ret.addReturnValue(rv);
        return ret;
    }

    public String getName() {
        return NEW;
    }

    public Class[] getParameter() {
        return new Class[]{ValueParam[].class};
    }

    public int getReturnType() {
        return 9;
    }

    public String toPPString(Parameter[] params, int indents) {
        if (params != null && params.length > 0) {
            StringBuffer buf = new StringBuffer();
            buf.append("(new");
            int idx = 0;
            while (idx < params.length) {
                if (params[idx] instanceof BoundParam) {
                    BoundParam bp = (BoundParam)params[idx];
                    buf.append(" ?" + bp.getVariableName());
                } else if (params[idx] instanceof ValueParam) {
                    buf.append(" " + params[idx].getStringValue());
                } else {
                    buf.append(" " + params[idx].getStringValue());
                }
                ++idx;
            }
            buf.append(")");
            return buf.toString();
        }
        return "(new (<literal> | <binding> | <value>)+)\n";
    }
}

