/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete.functions.java;

import java.io.Serializable;
import org.jamocha.rete.AbstractParam;
import org.jamocha.rete.BoundParam;
import org.jamocha.rete.DefaultReturnValue;
import org.jamocha.rete.DefaultReturnVector;
import org.jamocha.rete.Function;
import org.jamocha.rete.FunctionGroup;
import org.jamocha.rete.FunctionParam2;
import org.jamocha.rete.Parameter;
import org.jamocha.rete.Rete;
import org.jamocha.rete.ReturnVector;
import org.jamocha.rete.ValueParam;
import org.jamocha.rete.functions.java.ClassnameResolver;

public class LoadPackageFunction
implements Function,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String FUNCTION_NAME = "load-package";
    private ClassnameResolver classnameResolver;

    public LoadPackageFunction(ClassnameResolver classnameResolver) {
        this.classnameResolver = classnameResolver;
    }

    public ReturnVector executeFunction(Rete engine, Parameter[] params) {
        Object o = null;
        String classname = null;
        if (params != null && params.length == 1) {
            AbstractParam n;
            if (params[0] instanceof ValueParam) {
                n = (ValueParam)params[0];
                classname = n.getStringValue();
            } else if (params[0] instanceof BoundParam) {
                BoundParam bp = (BoundParam)params[0];
                classname = (String)engine.getBinding(bp.getVariableName());
            } else if (params[0] instanceof FunctionParam2) {
                n = (FunctionParam2)params[0];
                ((FunctionParam2)n).setEngine(engine);
                ((FunctionParam2)n).lookUpFunction();
                ReturnVector rval = (ReturnVector)((FunctionParam2)n).getValue();
                classname = rval.firstReturnValue().getStringValue();
            }
            try {
                Class<?> classDefinition = this.classnameResolver.resolveClass(classname);
                o = classDefinition.newInstance();
                if (o instanceof FunctionGroup) {
                    engine.declareFunctionGroup((FunctionGroup)o);
                }
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        DefaultReturnVector ret = new DefaultReturnVector();
        DefaultReturnValue rv = new DefaultReturnValue(9, o);
        ret.addReturnValue(rv);
        return ret;
    }

    public String getName() {
        return FUNCTION_NAME;
    }

    public Class[] getParameter() {
        return new Class[]{ValueParam[].class};
    }

    public int getReturnType() {
        return 9;
    }

    public String toPPString(Parameter[] params, int indents) {
        if (params != null && params.length > 0) {
            StringBuffer buf = new StringBuffer();
            buf.append("(load-package");
            int idx = 0;
            while (idx < params.length) {
                if (params[idx] instanceof BoundParam) {
                    BoundParam bp = (BoundParam)params[idx];
                    buf.append(" ?" + bp.getVariableName());
                } else if (params[idx] instanceof ValueParam) {
                    buf.append(" " + params[idx].getStringValue());
                } else {
                    buf.append(" " + params[idx].getStringValue());
                }
                ++idx;
            }
            buf.append(")");
            return buf.toString();
        }
        return "(load-package <classname>)\n";
    }
}

