/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete.functions.java;

import java.io.Serializable;
import org.jamocha.rete.BoundParam;
import org.jamocha.rete.DefaultReturnValue;
import org.jamocha.rete.DefaultReturnVector;
import org.jamocha.rete.Function;
import org.jamocha.rete.Parameter;
import org.jamocha.rete.Rete;
import org.jamocha.rete.ReturnVector;
import org.jamocha.rete.ValueParam;
import org.jamocha.rete.functions.java.ClassnameResolver;

public class InstanceofFunction
implements Function,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String INSTANCEOF = "instanceof";
    private ClassnameResolver classnameResolver;

    public InstanceofFunction(ClassnameResolver classnameResolver) {
        this.classnameResolver = classnameResolver;
    }

    public ReturnVector executeFunction(Rete engine, Parameter[] params) {
        boolean eval = false;
        if (params.length == 2) {
            Object param1 = null;
            if (params[0] instanceof BoundParam && params[1] instanceof BoundParam) {
                param1 = ((BoundParam)params[0]).getObjectRef();
                try {
                    Class<?> clazz = this.classnameResolver.resolveClass(((BoundParam)params[1]).getStringValue());
                    eval = clazz.isInstance(param1);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        DefaultReturnVector ret = new DefaultReturnVector();
        DefaultReturnValue rv = new DefaultReturnValue(20, new Boolean(eval));
        ret.addReturnValue(rv);
        return ret;
    }

    public String getName() {
        return INSTANCEOF;
    }

    public Class[] getParameter() {
        return new Class[]{BoundParam.class, BoundParam.class};
    }

    public int getReturnType() {
        return 20;
    }

    public String toPPString(Parameter[] params, int indents) {
        if (params != null && params.length > 0) {
            StringBuffer buf = new StringBuffer();
            buf.append("(instanceof");
            int idx = 0;
            while (idx < params.length) {
                if (params[idx] instanceof BoundParam) {
                    BoundParam bp = (BoundParam)params[idx];
                    buf.append(" ?" + bp.getVariableName());
                } else if (params[idx] instanceof ValueParam) {
                    buf.append(" " + params[idx].getStringValue());
                } else {
                    buf.append(" " + params[idx].getStringValue());
                }
                ++idx;
            }
            buf.append(")");
            return buf.toString();
        }
        return "(instanceof <Java-object> <class-name>)\n";
    }
}

