/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete.functions.java;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jamocha.rete.BoundParam;
import org.jamocha.rete.DefaultReturnValue;
import org.jamocha.rete.DefaultReturnVector;
import org.jamocha.rete.Defclass;
import org.jamocha.rete.Function;
import org.jamocha.rete.Parameter;
import org.jamocha.rete.Rete;
import org.jamocha.rete.ReturnVector;
import org.jamocha.rete.ValueParam;

public class GetMemberFunction
implements Function,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String GET_MEMBER = "get-member";

    public int getReturnType() {
        return 9;
    }

    public ReturnVector executeFunction(Rete engine, Parameter[] params) {
        Object rtn = null;
        DefaultReturnVector drv = new DefaultReturnVector();
        DefaultReturnValue rvalue = null;
        if (engine != null && params != null && params.length == 2) {
            BoundParam bp = (BoundParam)params[0];
            ValueParam slot = (ValueParam)params[1];
            Object instance = bp.getValue(engine, 9);
            Defclass dc = engine.findDefclass(instance);
            if (dc != null) {
                Method getm = dc.getReadMethod(slot.getStringValue());
                try {
                    rtn = getm.invoke(instance, new Object[0]);
                    int rtype = this.getMethodReturnType(getm);
                    rvalue = new DefaultReturnValue(rtype, rtn);
                }
                catch (IllegalAccessException e) {
                    rvalue = new DefaultReturnValue(11, "IllegalAccessException: could not invoke the method due to access privledge");
                }
                catch (InvocationTargetException e) {
                    rvalue = new DefaultReturnValue(11, "InvocationTargetException: could not invoke the method");
                }
            }
        }
        drv.addReturnValue(rvalue);
        return drv;
    }

    public String getName() {
        return GET_MEMBER;
    }

    public Class[] getParameter() {
        return new Class[]{BoundParam.class, ValueParam.class};
    }

    public int getMethodReturnType(Method m) {
        if (m.getReturnType() == String.class) {
            return 11;
        }
        if (m.getReturnType() == Integer.TYPE || m.getReturnType() == Integer.class) {
            return 1;
        }
        if (m.getReturnType() == Short.TYPE || m.getReturnType() == Short.class) {
            return 2;
        }
        if (m.getReturnType() == Long.TYPE || m.getReturnType() == Long.class) {
            return 3;
        }
        if (m.getReturnType() == Float.TYPE || m.getReturnType() == Float.class) {
            return 4;
        }
        if (m.getReturnType() == Double.TYPE || m.getReturnType() == Double.class) {
            return 5;
        }
        return 9;
    }

    public String toPPString(Parameter[] params, int indents) {
        if (params != null && params.length > 0) {
            StringBuffer buf = new StringBuffer();
            return buf.toString();
        }
        return "(get-member <binding> <slot>)";
    }
}

