/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete.functions.java;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.jamocha.logging.LogFactory;
import org.jamocha.logging.Logger;
import org.jamocha.rete.BoundParam;
import org.jamocha.rete.DefaultReturnValue;
import org.jamocha.rete.DefaultReturnVector;
import org.jamocha.rete.Defclass;
import org.jamocha.rete.Function;
import org.jamocha.rete.FunctionParam2;
import org.jamocha.rete.Parameter;
import org.jamocha.rete.Rete;
import org.jamocha.rete.ReturnVector;
import org.jamocha.rete.ValueParam;
import org.jamocha.rete.exception.AssertException;

public class DefinstanceFunction
implements Function,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String DEFINSTANCE = "definstance";
    private Logger log = LogFactory.createLogger(DefinstanceFunction.class);

    public int getReturnType() {
        return 11;
    }

    public ReturnVector executeFunction(Rete engine, Parameter[] params) {
        String asrt = "";
        Object instance = null;
        if (params.length >= 1 && params[0] != null) {
            if (params[0] instanceof FunctionParam2) {
                FunctionParam2 func = (FunctionParam2)params[0];
                String classname = func.getFunctionName();
                try {
                    Defclass defclass = engine.findDefclassByName(classname);
                    if (defclass != null) {
                        instance = defclass.getClassObject().newInstance();
                        Parameter[] parameters = func.getParameters();
                        int idx = 0;
                        while (idx < parameters.length) {
                            if (parameters[idx] instanceof FunctionParam2) {
                                FunctionParam2 fp = (FunctionParam2)parameters[idx];
                                String slotname = fp.getFunctionName();
                                ValueParam paramVal = (ValueParam)fp.getParameters()[0];
                                Class<?> returnType = defclass.getReadMethod(slotname).getReturnType();
                                Object value = this.getTypedValue(paramVal, returnType);
                                defclass.getWriteMethod(slotname).invoke(instance, value);
                            }
                            ++idx;
                        }
                    }
                }
                catch (InstantiationException e) {
                    this.log.debug(e);
                }
                catch (IllegalAccessException e) {
                    this.log.debug(e);
                }
                catch (IllegalArgumentException e) {
                    this.log.debug(e);
                }
                catch (InvocationTargetException e) {
                    this.log.debug(e);
                }
            } else if (params[0] instanceof BoundParam) {
                instance = ((BoundParam)params[0]).getValue(engine, 9);
            } else if (params[0] instanceof ValueParam) {
                instance = params[0].getValue();
            }
            String template = null;
            if (params.length == 2 && params[1].getStringValue() != null) {
                template = params[1].getStringValue();
            }
            try {
                engine.assertObject(instance, template, true, false);
                asrt = "true";
            }
            catch (AssertException e) {
                asrt = "false";
            }
        } else {
            asrt = "false";
        }
        DefaultReturnVector ret = new DefaultReturnVector();
        DefaultReturnValue rv = new DefaultReturnValue(11, asrt);
        ret.addReturnValue(rv);
        return ret;
    }

    protected Object getTypedValue(ValueParam param, Class clzz) {
        if (clzz == String.class) {
            return param.getStringValue();
        }
        if (clzz == Integer.TYPE || clzz == Integer.class) {
            return new Integer(param.getIntValue());
        }
        if (clzz == Short.TYPE || clzz == Short.class) {
            return new Short(param.getShortValue());
        }
        if (clzz == Float.TYPE || clzz == Float.class) {
            return new Float(param.getFloatValue());
        }
        if (clzz == Long.TYPE || clzz == Long.class) {
            return new Long(param.getLongValue());
        }
        if (clzz == Double.TYPE || clzz == Double.class) {
            return new Double(param.getDoubleValue());
        }
        if (clzz == BigDecimal.class) {
            return param.getBigDecimalValue();
        }
        if (clzz == BigInteger.class) {
            return param.getBigIntegerValue();
        }
        return param.getValue();
    }

    public String getName() {
        return DEFINSTANCE;
    }

    public Class[] getParameter() {
        return new Class[]{BoundParam.class, ValueParam.class};
    }

    public String toPPString(Parameter[] params, int indents) {
        if (params != null && params.length > 0) {
            StringBuffer buf = new StringBuffer();
            return buf.toString();
        }
        return "(definstance )";
    }
}

