/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete.functions.java;

import java.io.Serializable;
import org.jamocha.rete.DefaultReturnValue;
import org.jamocha.rete.DefaultReturnVector;
import org.jamocha.rete.Function;
import org.jamocha.rete.Parameter;
import org.jamocha.rete.Rete;
import org.jamocha.rete.ReturnVector;
import org.jamocha.rete.ValueParam;

public class DefclassFunction
implements Function,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String DEFCLASS = "defclass";

    public int getReturnType() {
        return 20;
    }

    public ReturnVector executeFunction(Rete engine, Parameter[] params) {
        boolean def = true;
        if (params.length >= 0) {
            String clazz = params[0].getStringValue();
            String template = null;
            if (params.length >= 2 && params[1] != null) {
                template = params[1].getStringValue();
            }
            String parent = null;
            if (params.length == 3) {
                parent = params[2].getStringValue();
            }
            try {
                engine.declareObject(clazz, template, parent);
            }
            catch (ClassNotFoundException e) {
                def = false;
            }
        } else {
            def = false;
        }
        DefaultReturnVector ret = new DefaultReturnVector();
        DefaultReturnValue rv = new DefaultReturnValue(20, new Boolean(def));
        ret.addReturnValue(rv);
        return ret;
    }

    public String getName() {
        return DEFCLASS;
    }

    public Class[] getParameter() {
        return new Class[]{ValueParam.class, ValueParam.class, ValueParam.class};
    }

    public String toPPString(Parameter[] params, int indents) {
        if (params != null && params.length > 0) {
            StringBuffer buf = new StringBuffer();
            buf.append("(defclass");
            int idx = 0;
            while (idx < params.length) {
                buf.append(" " + params[idx].getStringValue());
                ++idx;
            }
            buf.append(")");
            return buf.toString();
        }
        return "(defclass [new classname] [template] [parent template])";
    }
}

