/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete.functions.io;

import java.io.Serializable;
import org.jamocha.rete.BoundParam;
import org.jamocha.rete.Constants;
import org.jamocha.rete.DefaultReturnVector;
import org.jamocha.rete.Fact;
import org.jamocha.rete.Function;
import org.jamocha.rete.Parameter;
import org.jamocha.rete.Rete;
import org.jamocha.rete.ReturnVector;
import org.jamocha.rete.ValueParam;

public class PrintFunction
implements Function,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String PRINTOUT = "printout";

    public int getReturnType() {
        return 12;
    }

    public ReturnVector executeFunction(Rete engine, Parameter[] params) {
        if (params.length > 0) {
            String output = params[0].getStringValue();
            int idx = 1;
            while (idx < params.length) {
                if (params[idx] instanceof BoundParam) {
                    BoundParam bp = (BoundParam)params[idx];
                    Object v = engine.getBinding(bp.getVariableName());
                    if (v.getClass().isArray()) {
                        Object[] ary = (Object[])v;
                        this.writeArray(ary, engine, output, false);
                    } else {
                        engine.writeMessage(v.toString(), output);
                    }
                } else if (params[idx].getValue() != null && params[idx].getValue().equals("crlf")) {
                    engine.writeMessage(Constants.LINEBREAK, output);
                } else {
                    Object val = params[idx].getValue();
                    if (val instanceof String) {
                        engine.writeMessage((String)val, output);
                    } else if (val.getClass().isArray()) {
                        Object[] ary = (Object[])val;
                        this.writeArray(ary, engine, output, true);
                    } else {
                        engine.writeMessage(val.toString(), output);
                    }
                }
                ++idx;
            }
        }
        return new DefaultReturnVector();
    }

    public void writeArray(Object[] arry, Rete engine, String output, boolean linebreak) {
        int idz = 0;
        while (idz < arry.length) {
            Object val = arry[idz];
            if (val instanceof Fact) {
                Fact f = (Fact)val;
                engine.writeMessage(String.valueOf(f.toFactString()) + " ", output);
            } else {
                engine.writeMessage(String.valueOf(arry[idz].toString()) + " ", output);
            }
            if (linebreak) {
                engine.writeMessage(Constants.LINEBREAK, output);
            }
            ++idz;
        }
    }

    public String getName() {
        return PRINTOUT;
    }

    public Class[] getParameter() {
        return new Class[]{ValueParam[].class};
    }

    public String toPPString(Parameter[] params, int indents) {
        if (params != null && params.length > 0) {
            StringBuffer buf = new StringBuffer();
            buf.append("(print ");
            buf.append(params[0].getStringValue());
            int idx = 1;
            while (idx < params.length) {
                if (params[idx] instanceof BoundParam) {
                    BoundParam bp = (BoundParam)params[idx];
                    buf.append(" ?" + bp.getVariableName());
                } else {
                    buf.append(" \"" + params[idx].getStringValue() + "\"");
                }
                ++idx;
            }
            buf.append(" )");
            return buf.toString();
        }
        return "(print)";
    }
}

