/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete.functions.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import org.jamocha.parser.clips.CLIPSParser;
import org.jamocha.parser.clips.ParseException;
import org.jamocha.rete.BoundParam;
import org.jamocha.rete.Constants;
import org.jamocha.rete.DefaultReturnValue;
import org.jamocha.rete.DefaultReturnVector;
import org.jamocha.rete.Deffact;
import org.jamocha.rete.Deftemplate;
import org.jamocha.rete.Function;
import org.jamocha.rete.Parameter;
import org.jamocha.rete.Rete;
import org.jamocha.rete.ReturnVector;
import org.jamocha.rete.ValueParam;
import org.jamocha.rete.exception.AssertException;

public class LoadStreamFunction
implements Function,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String LOAD_STREAM = "load-stream";

    public int getReturnType() {
        return 20;
    }

    public ReturnVector executeFunction(Rete engine, Parameter[] params) {
        DefaultReturnVector rv = new DefaultReturnVector();
        boolean loaded = true;
        if (params != null && params.length > 0) {
            int idx = 0;
            while (idx < params.length) {
                String input = null;
                if (params[idx] instanceof ValueParam) {
                    input = ((ValueParam)params[idx]).getStringValue();
                } else {
                    boolean cfr_ignored_0 = params[idx] instanceof BoundParam;
                }
                if (input.indexOf(92) > -1) {
                    input.replaceAll("\\", "/");
                }
                if (input.indexOf(":") < 0 && !input.startsWith("/") && !input.startsWith("./")) {
                    input = "./" + input;
                }
                try {
                    InputStream inStream = LoadStreamFunction.getInputStream(input);
                    CLIPSParser parser = new CLIPSParser(inStream);
                    Object data = null;
                    while ((data = parser.streamExpr()) != null) {
                        ValueParam[] vp = (ValueParam[])data;
                        Deftemplate tmpl = (Deftemplate)engine.getCurrentFocus().getTemplate(vp[0].getStringValue());
                        Deffact fact = (Deffact)tmpl.createFact((Object[])vp[1].getValue(), -1L);
                        engine.assertFact(fact);
                    }
                }
                catch (FileNotFoundException e) {
                    loaded = false;
                    engine.writeMessage(String.valueOf(e.getMessage()) + Constants.LINEBREAK, Constants.DEFAULT_OUTPUT);
                }
                catch (ParseException e) {
                    loaded = false;
                    engine.writeMessage(String.valueOf(e.getMessage()) + Constants.LINEBREAK, Constants.DEFAULT_OUTPUT);
                }
                catch (AssertException e) {
                    loaded = false;
                    engine.writeMessage(String.valueOf(e.getMessage()) + Constants.LINEBREAK, Constants.DEFAULT_OUTPUT);
                }
                catch (IOException e) {
                    loaded = false;
                    engine.writeMessage(String.valueOf(e.getMessage()) + Constants.LINEBREAK, Constants.DEFAULT_OUTPUT);
                }
                ++idx;
            }
        } else {
            loaded = false;
        }
        DefaultReturnValue drv = new DefaultReturnValue(20, new Boolean(loaded));
        rv.addReturnValue(drv);
        return rv;
    }

    public String getName() {
        return LOAD_STREAM;
    }

    public Class[] getParameter() {
        return new Class[]{ValueParam.class};
    }

    public static InputStream getInputStream(String input) throws FileNotFoundException, IOException {
        InputStream inStream = null;
        if (input.matches("^[a-zA-Z]+://.*")) {
            URL url = new URL(input);
            inStream = url.openConnection().getInputStream();
        } else {
            inStream = new FileInputStream(new File(input));
        }
        return inStream;
    }

    public String toPPString(Parameter[] params, int indents) {
        if (params != null && params.length > 0) {
            StringBuffer buf = new StringBuffer();
            buf.append("(load-stream");
            int idx = 0;
            while (idx < params.length) {
                if (params[idx] instanceof BoundParam) {
                    BoundParam bp = (BoundParam)params[idx];
                    buf.append(" ?" + bp.getVariableName());
                } else if (params[idx] instanceof ValueParam) {
                    buf.append(" \"" + params[idx].getStringValue() + "\"");
                }
                ++idx;
            }
            buf.append(")");
            return buf.toString();
        }
        return "(load-stream <filename>)\nCommand description:\n\tLoad the file <filename>.";
    }
}

