/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete.functions.io;

import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import org.jamocha.parser.clips.CLIPSParser;
import org.jamocha.parser.clips.ParseException;
import org.jamocha.rete.Constants;
import org.jamocha.rete.DefaultReturnValue;
import org.jamocha.rete.DefaultReturnVector;
import org.jamocha.rete.Deftemplate;
import org.jamocha.rete.Function;
import org.jamocha.rete.Parameter;
import org.jamocha.rete.Rete;
import org.jamocha.rete.ReturnVector;
import org.jamocha.rete.ValueParam;
import org.jamocha.rule.Defrule;

public class BuildFunction
implements Function,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String BUILD = "build";

    public int getReturnType() {
        return 20;
    }

    public ReturnVector executeFunction(Rete engine, Parameter[] params) {
        DefaultReturnVector rv = new DefaultReturnVector();
        if (params != null && params.length == 1) {
            String input = params[0].getStringValue();
            StringReader reader = new StringReader(input);
            this.parse(engine, reader, rv);
            reader.close();
        }
        return rv;
    }

    public void parse(Rete engine, Reader reader, DefaultReturnVector rv) {
        try {
            CLIPSParser parser = new CLIPSParser(engine, reader);
            Object expr = null;
            while ((expr = parser.basicExpr()) != null) {
                if (expr instanceof Defrule) {
                    Defrule rl = (Defrule)expr;
                    engine.getRuleCompiler().addRule(rl);
                    continue;
                }
                if (expr instanceof Deftemplate) {
                    Deftemplate dft = (Deftemplate)expr;
                    engine.getCurrentFocus().addTemplate(dft, engine, engine.getWorkingMemory());
                    continue;
                }
                if (!(expr instanceof Function)) continue;
                Function fnc = (Function)expr;
                fnc.executeFunction(engine, null);
            }
            if (rv != null) {
                rv.addReturnValue(new DefaultReturnValue(20, new Boolean(true)));
            }
        }
        catch (ParseException e) {
            engine.writeMessage(String.valueOf(e.getMessage()) + Constants.LINEBREAK, Constants.DEFAULT_OUTPUT);
        }
    }

    public String getName() {
        return BUILD;
    }

    public Class[] getParameter() {
        return new Class[]{ValueParam.class};
    }

    public String toPPString(Parameter[] params, int indents) {
        return "(build)";
    }
}

