/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete.functions.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import org.jamocha.parser.clips.CLIPSParser;
import org.jamocha.parser.clips.ParseException;
import org.jamocha.rete.BoundParam;
import org.jamocha.rete.Constants;
import org.jamocha.rete.DefaultReturnValue;
import org.jamocha.rete.DefaultReturnVector;
import org.jamocha.rete.Deftemplate;
import org.jamocha.rete.Function;
import org.jamocha.rete.Parameter;
import org.jamocha.rete.Rete;
import org.jamocha.rete.ReturnVector;
import org.jamocha.rete.ValueParam;
import org.jamocha.rule.Defrule;

public class BatchFunction
implements Function,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String BATCH = "batch";

    public int getReturnType() {
        return 20;
    }

    public ReturnVector executeFunction(Rete engine, Parameter[] params) {
        DefaultReturnVector rv = new DefaultReturnVector();
        if (params != null && params.length > 0) {
            int idx = 0;
            while (idx < params.length) {
                try {
                    InputStream inStream;
                    String input = params[idx].getStringValue();
                    if (input.matches("^[a-zA-Z]+://.*")) {
                        URL url = new URL(input);
                        inStream = url.openConnection().getInputStream();
                    } else {
                        inStream = new FileInputStream(new File(input));
                    }
                    this.parse(engine, inStream, rv);
                    inStream.close();
                }
                catch (FileNotFoundException e) {
                    rv.addReturnValue(new DefaultReturnValue(20, new Boolean(false)));
                    engine.writeMessage(String.valueOf(e.getMessage()) + Constants.LINEBREAK, Constants.DEFAULT_OUTPUT);
                }
                catch (IOException e) {
                    rv.addReturnValue(new DefaultReturnValue(20, new Boolean(false)));
                    engine.writeMessage(String.valueOf(e.getMessage()) + Constants.LINEBREAK, Constants.DEFAULT_OUTPUT);
                }
                ++idx;
            }
        }
        return rv;
    }

    public void parse(Rete engine, InputStream ins, DefaultReturnVector rv) {
        try {
            CLIPSParser parser = new CLIPSParser(engine, ins);
            Object expr = null;
            while ((expr = parser.basicExpr()) != null) {
                if (expr instanceof Defrule) {
                    Defrule rl = (Defrule)expr;
                    engine.getRuleCompiler().addRule(rl);
                    continue;
                }
                if (expr instanceof Deftemplate) {
                    Deftemplate dft = (Deftemplate)expr;
                    engine.getCurrentFocus().addTemplate(dft, engine, engine.getWorkingMemory());
                    continue;
                }
                if (!(expr instanceof Function)) continue;
                Function fnc = (Function)expr;
                fnc.executeFunction(engine, null);
            }
            if (rv != null) {
                rv.addReturnValue(new DefaultReturnValue(20, new Boolean(true)));
            }
        }
        catch (ParseException e) {
            engine.writeMessage(String.valueOf(e.getMessage()) + Constants.LINEBREAK, Constants.DEFAULT_OUTPUT);
        }
    }

    public String getName() {
        return BATCH;
    }

    public Class[] getParameter() {
        return new Class[]{ValueParam.class};
    }

    public String toPPString(Parameter[] params, int indents) {
        if (params != null && params.length > 0) {
            StringBuffer buf = new StringBuffer();
            buf.append("(batch");
            int idx = 0;
            while (idx < params.length) {
                if (params[idx] instanceof BoundParam) {
                    BoundParam bp = (BoundParam)params[idx];
                    buf.append(" ?" + bp.getVariableName());
                } else if (params[idx] instanceof ValueParam) {
                    buf.append(" \"" + params[idx].getStringValue() + "\"");
                }
                ++idx;
            }
            buf.append(")");
            return buf.toString();
        }
        return "(batch <filename>)\nCommand description:\n\tLoads and executes the file <filename>.";
    }
}

