/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete.functions.cube;

import org.jamocha.rete.Cube;
import org.jamocha.rete.DefaultReturnValue;
import org.jamocha.rete.DefaultReturnVector;
import org.jamocha.rete.Function;
import org.jamocha.rete.Parameter;
import org.jamocha.rete.Rete;
import org.jamocha.rete.ReturnVector;

public class ProfileCubeFunction
implements Function {
    private static final long serialVersionUID = 1L;
    public static final String PROFILE_CUBE = "profile-cube";

    public ReturnVector executeFunction(Rete engine, Parameter[] params) {
        boolean profile = false;
        if (params != null && params.length > 0) {
            int idx = 0;
            while (idx < params.length) {
                String cubename = params[idx].getStringValue();
                Cube c = engine.getCube(cubename);
                if (c != null) {
                    c.setProfileQuery(true);
                    profile = true;
                }
                ++idx;
            }
        }
        DefaultReturnVector ret = new DefaultReturnVector();
        DefaultReturnValue rv = new DefaultReturnValue(20, new Boolean(profile));
        ret.addReturnValue(rv);
        return ret;
    }

    public String getName() {
        return PROFILE_CUBE;
    }

    public Class[] getParameter() {
        return new Class[]{String.class};
    }

    public int getReturnType() {
        return 12;
    }

    public String toPPString(Parameter[] params, int indents) {
        return "(profile-cube <name>)";
    }
}

