/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete.functions.cube;

import org.jamocha.rete.DefaultReturnValue;
import org.jamocha.rete.DefaultReturnVector;
import org.jamocha.rete.Function;
import org.jamocha.rete.Parameter;
import org.jamocha.rete.Rete;
import org.jamocha.rete.ReturnVector;
import org.jamocha.rete.measures.Measure;

public class LoadMeasureFunction
implements Function {
    private static final long serialVersionUID = 1L;
    public static final String LOAD_MEASURE = "load-measure";

    public ReturnVector executeFunction(Rete engine, Parameter[] params) {
        boolean load = false;
        if (params != null && params.length > 0) {
            int idx = 0;
            while (idx < params.length) {
                String className = params[idx].getStringValue();
                try {
                    Class<?> clzz = Class.forName(className);
                    Measure measure = (Measure)clzz.newInstance();
                    engine.declareMeasure(measure);
                    load = true;
                }
                catch (ClassNotFoundException e) {
                    engine.writeMessage("Could not find the class. Please double check and make sure it is the fully qualified class name.");
                }
                catch (InstantiationException e) {
                    engine.writeMessage("Could not create new instance of the class.");
                }
                catch (IllegalAccessException e) {
                    engine.writeMessage("Could not create new instance of the class.");
                }
                ++idx;
            }
        }
        DefaultReturnVector ret = new DefaultReturnVector();
        DefaultReturnValue rv = new DefaultReturnValue(20, new Boolean(load));
        ret.addReturnValue(rv);
        return ret;
    }

    public String getName() {
        return LOAD_MEASURE;
    }

    public Class[] getParameter() {
        return new Class[]{String[].class};
    }

    public int getReturnType() {
        return 20;
    }

    public String toPPString(Parameter[] params, int indents) {
        return "(load-measure <class>+)";
    }
}

