/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete.functions.cube;

import org.jamocha.rete.DefaultReturnValue;
import org.jamocha.rete.DefaultReturnVector;
import org.jamocha.rete.Defcube;
import org.jamocha.rete.Function;
import org.jamocha.rete.Parameter;
import org.jamocha.rete.Rete;
import org.jamocha.rete.ReturnVector;

public class IndexDimensionFunction
implements Function {
    private static final long serialVersionUID = 1L;
    public static final String INDEX_DIMENSION = "index-dimension";

    public ReturnVector executeFunction(Rete engine, Parameter[] params) {
        boolean index = false;
        if (params != null && params.length >= 2) {
            String cubename = params[0].getStringValue();
            Defcube cube = (Defcube)engine.getCube(cubename);
            int i = 1;
            while (i < params.length) {
                String dimension = params[i].getStringValue();
                cube.getDimension(dimension).setAutoIndex(true);
                ++i;
            }
            index = true;
        }
        DefaultReturnVector ret = new DefaultReturnVector();
        DefaultReturnValue rv = new DefaultReturnValue(20, new Boolean(index));
        ret.addReturnValue(rv);
        return ret;
    }

    public String getName() {
        return INDEX_DIMENSION;
    }

    public Class[] getParameter() {
        return new Class[]{String.class, String[].class};
    }

    public int getReturnType() {
        return 20;
    }

    public String toPPString(Parameter[] params, int indents) {
        return "(index-dimension <cube> <dimension>+)";
    }
}

