/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete.functions.analysis;

import java.io.Serializable;
import org.jamocha.rete.BoundParam;
import org.jamocha.rete.DefaultReturnVector;
import org.jamocha.rete.Function;
import org.jamocha.rete.Parameter;
import org.jamocha.rete.Rete;
import org.jamocha.rete.ReturnVector;
import org.jamocha.rete.ValueParam;
import org.jamocha.rule.Defrule;
import org.jamocha.rule.util.TopologyCostCalculation;

public class TopologyCostFunction
implements Function,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String TOPOLOGY_COST = "topology-cost";
    TopologyCostCalculation costFunction = new TopologyCostCalculation();

    public int getReturnType() {
        return 12;
    }

    public ReturnVector executeFunction(Rete engine, Parameter[] params) {
        DefaultReturnVector ret = new DefaultReturnVector();
        if (params != null && params.length > 0) {
            String ruleName = null;
            int idx = 0;
            while (idx < params.length) {
                if (params[0] instanceof ValueParam) {
                    ValueParam n = (ValueParam)params[0];
                    ruleName = n.getStringValue();
                } else if (params[0] instanceof BoundParam) {
                    BoundParam bp = (BoundParam)params[0];
                    ruleName = (String)bp.getValue(engine, 11);
                }
                Defrule r = (Defrule)engine.getCurrentFocus().findRule(ruleName);
                this.costFunction.calculateCost(engine, r, engine.getRootNode());
                ++idx;
            }
        }
        return ret;
    }

    public String getName() {
        return TOPOLOGY_COST;
    }

    public Class[] getParameter() {
        return new Class[]{ValueParam[].class};
    }

    public String toPPString(Parameter[] params, int indents) {
        return "(topology-cost <literal>+)\nFunction description:\n\tCalculates the topology cost of one or more rules and sets the\n\tRule.costValue.";
    }
}

