/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete.functions.analysis;

import java.io.Serializable;
import java.util.Collection;
import org.jamocha.rete.DefaultReturnVector;
import org.jamocha.rete.Function;
import org.jamocha.rete.Module;
import org.jamocha.rete.Parameter;
import org.jamocha.rete.Rete;
import org.jamocha.rete.ReturnVector;
import org.jamocha.rete.ValueParam;
import org.jamocha.rule.Defrule;
import org.jamocha.rule.util.TopologyCostCalculation;

public class TopologyCostAllFunction
implements Function,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String TOPOLOGY_COST_ALL = "topology-cost-all";
    private TopologyCostCalculation costFunction = new TopologyCostCalculation();

    public int getReturnType() {
        return 12;
    }

    public ReturnVector executeFunction(Rete engine, Parameter[] params) {
        DefaultReturnVector ret = new DefaultReturnVector();
        Collection modules = engine.getWorkingMemory().getModules();
        for (Module m : modules) {
            Collection rules = m.getAllRules();
            for (Defrule r : rules) {
                this.costFunction.calculateCost(engine, r, engine.getRootNode());
            }
        }
        return ret;
    }

    public String getName() {
        return TOPOLOGY_COST_ALL;
    }

    public Class[] getParameter() {
        return new Class[]{ValueParam[].class};
    }

    public String toPPString(Parameter[] params, int indents) {
        return "(topology-cost-all )\nFunction description:\n\tCalculates the topology cost of all rules and sets Rule.costValue.";
    }
}

