/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete.functions.analysis;

import java.io.Serializable;
import java.util.ArrayList;
import org.jamocha.rete.DefaultReturnValue;
import org.jamocha.rete.DefaultReturnVector;
import org.jamocha.rete.Deffact;
import org.jamocha.rete.Function;
import org.jamocha.rete.Parameter;
import org.jamocha.rete.Rete;
import org.jamocha.rete.ReturnVector;
import org.jamocha.rete.ValueParam;
import org.jamocha.rete.exception.AssertException;
import org.jamocha.rule.Defrule;
import org.jamocha.rule.util.GenerateFacts;

public class TestRuleFunction
implements Function,
Serializable {
    public static final String TESTRULE = "test-rule";

    public int getReturnType() {
        return 20;
    }

    public ReturnVector executeFunction(Rete engine, Parameter[] params) {
        DefaultReturnVector ret = new DefaultReturnVector();
        if (params != null && params.length == 1) {
            String rlz = params[0].getStringValue();
            Defrule r = (Defrule)engine.getCurrentFocus().findRule(params[0].getStringValue());
            ArrayList facts = GenerateFacts.generateFacts(r, engine);
            if (facts.size() > 0) {
                try {
                    engine.setWatch(2);
                    for (Object data : facts) {
                        if (data instanceof Deffact) {
                            engine.assertFact((Deffact)data);
                            continue;
                        }
                        engine.assertObject(data, null, false, true);
                    }
                    engine.fire();
                    engine.setUnWatch(2);
                }
                catch (AssertException e) {
                    e.printStackTrace();
                }
            }
        }
        DefaultReturnValue rv = new DefaultReturnValue(20, new Boolean(true));
        ret.addReturnValue(rv);
        return ret;
    }

    public String getName() {
        return TESTRULE;
    }

    public Class[] getParameter() {
        return new Class[]{ValueParam.class};
    }

    public String toPPString(Parameter[] params, int indents) {
        if (indents > 0) {
            StringBuffer buf = new StringBuffer();
            int idx = 0;
            while (idx < indents) {
                buf.append(" ");
                ++idx;
            }
            buf.append("(test-rule)");
            return buf.toString();
        }
        return "(test-rule [rule])\nFunction description:\n\tGenerate the facts for a rule, assert them and\n\tcall (fire).\n";
    }
}

