/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete.functions.analysis;

import java.math.BigDecimal;
import org.jamocha.rete.BaseSlot;
import org.jamocha.rete.DefaultReturnValue;
import org.jamocha.rete.DefaultReturnVector;
import org.jamocha.rete.Function;
import org.jamocha.rete.Parameter;
import org.jamocha.rete.Rete;
import org.jamocha.rete.ReturnVector;
import org.jamocha.rete.Template;
import org.jamocha.rete.ValueParam;

public class SetDistinctCount
implements Function {
    private static final long serialVersionUID = 1L;
    public static final String SET_DISTINCT_COUNT = "set-distinct-count";

    public ReturnVector executeFunction(Rete engine, Parameter[] params) {
        boolean success = false;
        if (params != null && params.length == 3) {
            String template = params[0].getStringValue();
            String slotname = params[1].getStringValue();
            BigDecimal count = params[2].getBigDecimalValue();
            Template deftemplate = engine.findTemplate(template);
            BaseSlot sl = deftemplate.getSlot(slotname);
            sl.setDistinctCount(count.longValue());
            success = true;
        }
        DefaultReturnVector returnVector = new DefaultReturnVector();
        DefaultReturnValue returnVal = new DefaultReturnValue(20, new Boolean(success));
        returnVector.addReturnValue(returnVal);
        return returnVector;
    }

    public String getName() {
        return SET_DISTINCT_COUNT;
    }

    public Class[] getParameter() {
        return new Class[]{ValueParam.class, ValueParam.class, ValueParam.class};
    }

    public int getReturnType() {
        return 20;
    }

    public String toPPString(Parameter[] params, int indents) {
        return "(set-distinct-coount <template> <slot> <distinct-count>)";
    }
}

