/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete.functions.analysis;

import java.io.Serializable;
import java.util.ArrayList;
import org.jamocha.rete.DefaultReturnValue;
import org.jamocha.rete.DefaultReturnVector;
import org.jamocha.rete.Deffact;
import org.jamocha.rete.Function;
import org.jamocha.rete.Parameter;
import org.jamocha.rete.Rete;
import org.jamocha.rete.ReturnVector;
import org.jamocha.rete.ValueParam;
import org.jamocha.rete.util.IOUtilities;
import org.jamocha.rule.Defrule;
import org.jamocha.rule.util.GenerateFacts;

public class GenerateFactsFunction
implements Function,
Serializable {
    public static final String GENERATEFACTS = "generate-facts";

    public int getReturnType() {
        return 9;
    }

    public ReturnVector executeFunction(Rete engine, Parameter[] params) {
        DefaultReturnVector ret = new DefaultReturnVector();
        boolean echo = false;
        ArrayList facts = null;
        String output = null;
        if (params != null && params.length >= 1) {
            Defrule r = (Defrule)engine.getCurrentFocus().findRule(params[0].getStringValue());
            if (params.length == 2 && params[1].getBooleanValue()) {
                echo = true;
            }
            if (params.length == 3) {
                output = params[2].getStringValue();
            }
            if ((facts = GenerateFacts.generateFacts(r, engine)).size() > 0) {
                if (echo) {
                    for (Object data : facts) {
                        if (data instanceof Deffact) {
                            Deffact f = (Deffact)data;
                            engine.writeMessage(f.toFactString());
                            continue;
                        }
                        engine.writeMessage(data.toString());
                    }
                }
                if (output != null) {
                    IOUtilities.saveFacts(facts, output);
                }
                DefaultReturnValue rv = new DefaultReturnValue(9, facts.toArray());
                ret.addReturnValue(rv);
            } else {
                DefaultReturnValue rv = new DefaultReturnValue(20, new Boolean(false));
                ret.addReturnValue(rv);
            }
        }
        return ret;
    }

    public String getName() {
        return GENERATEFACTS;
    }

    public Class[] getParameter() {
        return new Class[]{ValueParam.class};
    }

    public String toPPString(Parameter[] params, int indents) {
        if (indents > 0) {
            StringBuffer buf = new StringBuffer();
            int idx = 0;
            while (idx < indents) {
                buf.append(" ");
                ++idx;
            }
            buf.append("(generate-facts)");
            return buf.toString();
        }
        return "(generate-facts [<rule> [true | false] [output])\nFunction description:\n\tGenerates the trigger facts for a single rule\n";
    }
}

