/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete.functions.analysis;

import java.util.Collection;
import org.jamocha.rete.DefaultReturnValue;
import org.jamocha.rete.DefaultReturnVector;
import org.jamocha.rete.Function;
import org.jamocha.rete.Parameter;
import org.jamocha.rete.Rete;
import org.jamocha.rete.ReturnVector;
import org.jamocha.rule.Defrule;

public class AverageCostFunction
implements Function {
    private static final long serialVersionUID = 1L;
    public static final String AVERAGE_COST = "average-cost";

    public ReturnVector executeFunction(Rete engine, Parameter[] params) {
        DefaultReturnVector ret = new DefaultReturnVector();
        int total = 0;
        Collection rules = engine.getCurrentFocus().getAllRules();
        for (Defrule rule : rules) {
            total += rule.getCostValue();
        }
        int average = total / rules.size();
        DefaultReturnValue v = new DefaultReturnValue(14, new Integer(average));
        ret.addReturnValue(v);
        return ret;
    }

    public String getName() {
        return AVERAGE_COST;
    }

    public Class[] getParameter() {
        return new Class[0];
    }

    public int getReturnType() {
        return 14;
    }

    public String toPPString(Parameter[] params, int indents) {
        return "(average-cost)";
    }
}

