/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete.functions.agent;

import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import org.jamocha.rete.Constants;
import org.jamocha.rete.DefaultReturnVector;
import org.jamocha.rete.Function;
import org.jamocha.rete.Parameter;
import org.jamocha.rete.Rete;
import org.jamocha.rete.ReturnVector;
import org.jamocha.rete.functions.agent.AgentPerformanceSummary;
import org.jamocha.rete.functions.agent.AgentRegistry;

public class PrintAgentPerfSummaryFunction
implements Function {
    private static final long serialVersionUID = 1L;
    public static final String PRINT_AGENT_PERF = "pprint-agent-perf-summary";

    public ReturnVector executeFunction(Rete engine, Parameter[] params) {
        List summaries = AgentRegistry.getPerformanceSummaries();
        for (Queue queue : summaries) {
            Iterator perfItr = queue.iterator();
            String text = null;
            boolean x = false;
            while (perfItr.hasNext()) {
                AgentPerformanceSummary sum = (AgentPerformanceSummary)perfItr.next();
                text = "";
                if (!x) {
                    text = String.valueOf(text) + "IP Address: " + sum.getIPAddress();
                    text = String.valueOf(text) + " Hostname: " + sum.getHostname();
                    text = String.valueOf(text) + " Application: " + sum.getApplication();
                    text = String.valueOf(text) + Constants.LINEBREAK;
                }
                text = String.valueOf(text) + "    Ave Response: " + sum.getAverageResponseTime();
                text = String.valueOf(text) + "    Ave Fired: " + sum.getAverageRulesFired();
                text = String.valueOf(text) + "    Total Requests: " + sum.getRequests();
                text = String.valueOf(text) + "    Total Rules Fired: " + sum.getTotalRulesFired();
                text = String.valueOf(text) + Constants.LINEBREAK;
            }
        }
        DefaultReturnVector ret = new DefaultReturnVector();
        return ret;
    }

    public String getName() {
        return PRINT_AGENT_PERF;
    }

    public Class[] getParameter() {
        return new Class[0];
    }

    public int getReturnType() {
        return 12;
    }

    public String toPPString(Parameter[] params, int indents) {
        return "(pprint-agent-perf-summary)";
    }
}

