/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete.functions.agent;

import java.io.Serializable;
import org.jamocha.messaging.MessageClient;
import org.jamocha.rete.DefaultReturnVector;
import org.jamocha.rete.Function;
import org.jamocha.rete.Parameter;
import org.jamocha.rete.Rete;
import org.jamocha.rete.ReturnVector;

public class PingAgentFunction
implements Function {
    private static final long serialVersionUID = 1L;
    public static final String PING_AGENT = "ping-agent";

    public ReturnVector executeFunction(Rete engine, Parameter[] params) {
        Object value;
        if (params != null && params.length == 4 && (value = engine.getDefglobalValue(params[0].getStringValue())) != null && value instanceof MessageClient) {
            MessageClient client = (MessageClient)value;
            String ipaddr = params[1].getStringValue();
            String hostname = params[2].getStringValue();
            String app = params[3].getStringValue();
            if (!ipaddr.equals("all") && !hostname.equals("all")) {
                String message = "(get-agent-status \"" + ipaddr + "\" \"" + hostname + "\" \"" + app + "\" " + System.currentTimeMillis() + ")";
                client.publish((Serializable)((Object)message));
            } else {
                String message = "(get-agent-status \"all\" \"all\" \"all\" " + System.currentTimeMillis() + ")";
                client.publish((Serializable)((Object)message));
            }
        }
        DefaultReturnVector ret = new DefaultReturnVector();
        return ret;
    }

    public String getName() {
        return PING_AGENT;
    }

    public Class[] getParameter() {
        return new Class[]{String.class};
    }

    public int getReturnType() {
        return 12;
    }

    public String toPPString(Parameter[] params, int indents) {
        return "(ping-agent <*client instance name*> <ipaddress> <hostname> <application name>)";
    }
}

