/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete.functions.agent;

import org.jamocha.rete.Constants;
import org.jamocha.rete.DefaultReturnValue;
import org.jamocha.rete.DefaultReturnVector;
import org.jamocha.rete.Function;
import org.jamocha.rete.Parameter;
import org.jamocha.rete.Rete;
import org.jamocha.rete.ReturnVector;

public class AgentStatusResponseFunction
implements Function {
    private static final long serialVersionUID = 1L;
    public static final String AGENT_STATUS_RESPONSE = "agent-status-response";

    public ReturnVector executeFunction(Rete engine, Parameter[] params) {
        String response = "";
        if (params != null && params.length >= 2) {
            long sent = params[0].getLongValue();
            long agentTs = params[1].getLongValue();
            long et = System.currentTimeMillis() - sent;
            response = String.valueOf(response) + "Ping response time: " + et + Constants.LINEBREAK + "Agent received time: " + (agentTs - sent) + Constants.LINEBREAK;
            if (params.length == 5) {
                response = String.valueOf(response) + "IP Address: " + params[2].getStringValue() + Constants.LINEBREAK;
                response = String.valueOf(response) + "Hostname: " + params[3].getStringValue() + Constants.LINEBREAK;
                response = String.valueOf(response) + "Application: " + params[4].getStringValue() + Constants.LINEBREAK;
            }
            engine.writeMessage(response, "t");
        }
        DefaultReturnVector ret = new DefaultReturnVector();
        DefaultReturnValue rval = new DefaultReturnValue(11, response);
        ret.addReturnValue(rval);
        return ret;
    }

    public String getName() {
        return AGENT_STATUS_RESPONSE;
    }

    public Class[] getParameter() {
        return new Class[]{Long.TYPE, Long.TYPE};
    }

    public int getReturnType() {
        return 11;
    }

    public String toPPString(Parameter[] params, int indents) {
        return "(agent-status-response <sent timestamp> <agent timestamp>)";
    }
}

