/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete.functions.agent;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import org.jamocha.rete.functions.agent.AgentEntry;
import org.jamocha.rete.functions.agent.AgentPerformanceSummary;

public class AgentRegistry {
    private static Map agentRegistry = new HashMap();
    private static Map agentSummaries = new HashMap();

    public static void registerAgent(AgentEntry agent) {
        if (!agentRegistry.containsKey(agent.getKey())) {
            agentRegistry.put(agent.getKey(), agent);
        }
    }

    public static AgentEntry getAgent(String key) {
        return (AgentEntry)agentRegistry.get(key);
    }

    public static List getAgents() {
        return new ArrayList(agentRegistry.values());
    }

    public static AgentEntry removeAgent(AgentEntry agent) {
        return (AgentEntry)agentRegistry.remove(agent.getKey());
    }

    public static void addSummary(AgentPerformanceSummary summary) {
        PriorityQueue<AgentPerformanceSummary> queue = (PriorityQueue<AgentPerformanceSummary>)agentSummaries.get(summary.getKey());
        if (queue == null) {
            queue = new PriorityQueue<AgentPerformanceSummary>(50);
            agentSummaries.put(summary.getKey(), queue);
        }
        if (queue.size() == 50) {
            queue.remove();
        }
        queue.offer(summary);
    }

    public Queue getSummary(AgentPerformanceSummary summary) {
        PriorityQueue queue = (PriorityQueue)agentSummaries.get(summary.getKey());
        if (queue == null) {
            queue = new PriorityQueue(50);
            agentSummaries.put(summary.getKey(), queue);
        }
        return queue;
    }

    public static List getPerformanceSummaries() {
        return new ArrayList(agentSummaries.values());
    }
}

