/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete.functions;

import java.io.Serializable;
import org.jamocha.rete.DefaultReturnVector;
import org.jamocha.rete.Function;
import org.jamocha.rete.Parameter;
import org.jamocha.rete.Rete;
import org.jamocha.rete.ReturnVector;
import org.jamocha.rete.ValueParam;

public class WatchFunction
implements Function,
Serializable {
    private static final long serialVersionUID = 1L;
    protected static final String WATCH = "watch";

    public int getReturnType() {
        return 12;
    }

    public ReturnVector executeFunction(Rete engine, Parameter[] params) {
        if (params != null && params.length > 0) {
            int idx = 0;
            while (idx < params.length) {
                String cmd = params[idx].getStringValue();
                this.setWatch(engine, cmd);
                ++idx;
            }
        }
        DefaultReturnVector ret = new DefaultReturnVector();
        return ret;
    }

    protected void setWatch(Rete engine, String cmd) {
        if (cmd.equals("all")) {
            engine.setWatch(2);
        } else if (cmd.equals("facts")) {
            engine.setWatch(3);
        } else if (cmd.equals("activations")) {
            engine.setWatch(1);
        } else if (cmd.equals("rules")) {
            engine.setWatch(4);
        }
    }

    public String getName() {
        return WATCH;
    }

    public Class[] getParameter() {
        return new Class[]{ValueParam.class};
    }

    public String toPPString(Parameter[] params, int indents) {
        return "(watch activations|all|facts|rules)\nFunction description:\n\tAllows users to watch engine processes (activations, facts, rules).";
    }
}

