/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete.functions;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import org.jamocha.rete.DefaultReturnValue;
import org.jamocha.rete.DefaultReturnVector;
import org.jamocha.rete.Function;
import org.jamocha.rete.Parameter;
import org.jamocha.rete.Rete;
import org.jamocha.rete.ReturnVector;
import org.jamocha.rete.ValueParam;

public class SpoolFunction
implements Function,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SPOOL = "spool";
    public static final String DRIBBLE = "dribble";

    public int getReturnType() {
        return 20;
    }

    public ReturnVector executeFunction(Rete engine, Parameter[] params) {
        boolean sp = true;
        if (params != null && params.length >= 2) {
            String val = params[0].getStringValue();
            if (val.equals("off")) {
                String name = params[1].getStringValue();
                PrintWriter writer = engine.removePrintWriter(name);
                if (writer != null) {
                    writer.flush();
                    writer.close();
                }
            } else {
                String spname = params[0].getStringValue();
                String fname = params[1].getStringValue();
                try {
                    File nfile = new File(fname);
                    nfile.createNewFile();
                    FileOutputStream fos = new FileOutputStream(nfile);
                    PrintWriter writer = new PrintWriter(fos);
                    engine.addPrintWriter(spname, writer);
                }
                catch (FileNotFoundException e) {
                    sp = false;
                }
                catch (IOException e) {
                    sp = false;
                }
            }
        } else {
            sp = false;
        }
        DefaultReturnVector ret = new DefaultReturnVector();
        DefaultReturnValue rv = new DefaultReturnValue(20, new Boolean(sp));
        ret.addReturnValue(rv);
        return ret;
    }

    public String getName() {
        return SPOOL;
    }

    public Class[] getParameter() {
        return new Class[]{ValueParam.class};
    }

    public String toPPString(Parameter[] params, int indents) {
        return "(spool <name> <file>| off <name>)";
    }
}

