/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete.functions;

import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import org.jamocha.rete.Constants;
import org.jamocha.rete.DefaultReturnValue;
import org.jamocha.rete.DefaultReturnVector;
import org.jamocha.rete.Deffact;
import org.jamocha.rete.Function;
import org.jamocha.rete.Parameter;
import org.jamocha.rete.Rete;
import org.jamocha.rete.ReturnVector;
import org.jamocha.rete.ValueParam;
import org.jamocha.rete.util.FactUtils;

public class SaveFactsFunction
implements Function,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SAVE_FACTS = "save-facts";

    public int getReturnType() {
        return 20;
    }

    public ReturnVector executeFunction(Rete engine, Parameter[] params) {
        boolean saved = false;
        boolean sortid = true;
        DefaultReturnVector rv = new DefaultReturnVector();
        if (params != null && params.length >= 1) {
            if (params[1] != null && params[1].getStringValue().equals("template")) {
                sortid = false;
            }
            try {
                FileWriter writer = new FileWriter(params[0].getStringValue());
                List facts = engine.getAllFacts();
                Object[] sorted = null;
                sorted = sortid ? FactUtils.sortFacts(facts) : FactUtils.sortFactsByTemplate(facts);
                int idx = 0;
                while (idx < sorted.length) {
                    Deffact ft = (Deffact)sorted[idx];
                    writer.write(String.valueOf(ft.toPPString()) + Constants.LINEBREAK);
                    ++idx;
                }
                writer.close();
                saved = true;
            }
            catch (IOException writer) {
                // empty catch block
            }
        }
        DefaultReturnValue drv = new DefaultReturnValue(20, new Boolean(saved));
        rv.addReturnValue(drv);
        return rv;
    }

    public String getName() {
        return SAVE_FACTS;
    }

    public Class[] getParameter() {
        return new Class[]{ValueParam.class, ValueParam.class};
    }

    public String toPPString(Parameter[] params, int indents) {
        return "(save-facts [filename] [sort(id|template)])";
    }
}

