/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete.functions;

import java.io.Serializable;
import java.math.BigDecimal;
import org.jamocha.rete.BoundParam;
import org.jamocha.rete.DefaultReturnValue;
import org.jamocha.rete.DefaultReturnVector;
import org.jamocha.rete.Deffact;
import org.jamocha.rete.Function;
import org.jamocha.rete.Parameter;
import org.jamocha.rete.Rete;
import org.jamocha.rete.ReturnVector;
import org.jamocha.rete.ValueParam;
import org.jamocha.rete.exception.RetractException;

public class RetractFunction
implements Function,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String RETRACT = "retract";

    public int getReturnType() {
        return 12;
    }

    public ReturnVector executeFunction(Rete engine, Parameter[] params) {
        DefaultReturnVector rv = new DefaultReturnVector();
        if (params != null && params.length >= 1) {
            int idx = 0;
            while (idx < params.length) {
                DefaultReturnValue rval;
                if (params[idx] instanceof BoundParam) {
                    BoundParam bp = (BoundParam)params[idx];
                    Deffact fact = (Deffact)bp.getFact();
                    try {
                        if (fact.getObjectInstance() != null) {
                            engine.retractObject(fact.getObjectInstance());
                        } else {
                            engine.retractFact(fact);
                        }
                        rval = new DefaultReturnValue(20, new Boolean(true));
                        rv.addReturnValue(rval);
                    }
                    catch (RetractException e) {
                        DefaultReturnValue rval2 = new DefaultReturnValue(20, new Boolean(false));
                        rv.addReturnValue(rval2);
                    }
                } else if (params[idx] instanceof ValueParam) {
                    BigDecimal bi = params[idx].getBigDecimalValue();
                    try {
                        engine.retractById(bi.longValue());
                        DefaultReturnValue rval3 = new DefaultReturnValue(20, new Boolean(true));
                        rv.addReturnValue(rval3);
                    }
                    catch (RetractException e) {
                        rval = new DefaultReturnValue(20, new Boolean(false));
                        rv.addReturnValue(rval);
                    }
                }
                ++idx;
            }
        }
        return rv;
    }

    public String getName() {
        return RETRACT;
    }

    public Class[] getParameter() {
        return new Class[]{BoundParam.class};
    }

    public String toPPString(Parameter[] params, int indents) {
        return "(retract [?binding|fact-id])\nFunction description:\n\tAllows the user to remove facts from the fact-list.";
    }
}

