/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete.functions;

import java.io.Serializable;
import org.jamocha.rete.AbstractParam;
import org.jamocha.rete.BoundParam;
import org.jamocha.rete.DefaultReturnValue;
import org.jamocha.rete.DefaultReturnVector;
import org.jamocha.rete.Function;
import org.jamocha.rete.FunctionParam2;
import org.jamocha.rete.Parameter;
import org.jamocha.rete.Rete;
import org.jamocha.rete.ReturnVector;
import org.jamocha.rete.ValueParam;

public class NotFunction
implements Function,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String NOT = "not";

    public int getReturnType() {
        return 20;
    }

    public ReturnVector executeFunction(Rete engine, Parameter[] params) {
        boolean boolVal = true;
        if (params != null && params.length == 1) {
            AbstractParam n;
            if (params[0] instanceof ValueParam) {
                n = (ValueParam)params[0];
                boolVal = n.getBooleanValue();
            } else if (params[0] instanceof BoundParam) {
                BoundParam bp = (BoundParam)params[0];
                boolVal = (Boolean)engine.getBinding(bp.getVariableName());
            } else if (params[0] instanceof FunctionParam2) {
                n = (FunctionParam2)params[0];
                ((FunctionParam2)n).setEngine(engine);
                ((FunctionParam2)n).lookUpFunction();
                ReturnVector rval = (ReturnVector)((FunctionParam2)n).getValue();
                boolVal = rval.firstReturnValue().getBooleanValue();
            }
            boolVal = !boolVal;
        }
        DefaultReturnVector ret = new DefaultReturnVector();
        DefaultReturnValue rv = new DefaultReturnValue(20, new Boolean(boolVal));
        ret.addReturnValue(rv);
        return ret;
    }

    public String getName() {
        return NOT;
    }

    public Class[] getParameter() {
        return new Class[]{ValueParam[].class};
    }

    public String toPPString(Parameter[] params, int indents) {
        if (params != null && params.length >= 0) {
            StringBuffer buf = new StringBuffer();
            buf.append("(not");
            int idx = 0;
            if (params[idx] instanceof BoundParam) {
                BoundParam bp = (BoundParam)params[idx];
                buf.append(" ?" + bp.getVariableName());
            } else if (params[idx] instanceof ValueParam) {
                buf.append(" " + params[idx].getStringValue());
            } else {
                buf.append(" " + params[idx].getStringValue());
            }
            buf.append(")");
            return buf.toString();
        }
        return "(NOT <booleanexpression>)\nFunction description:\n\tReturns the boolean not of any boolean expression argument.";
    }
}

