/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete.functions;

import java.io.Serializable;
import org.jamocha.rete.BaseSlot;
import org.jamocha.rete.BoundParam;
import org.jamocha.rete.DefaultReturnValue;
import org.jamocha.rete.DefaultReturnVector;
import org.jamocha.rete.Deffact;
import org.jamocha.rete.Fact;
import org.jamocha.rete.Parameter;
import org.jamocha.rete.Rete;
import org.jamocha.rete.ReturnVector;
import org.jamocha.rete.RuleFunction;
import org.jamocha.rete.Slot;
import org.jamocha.rete.SlotParam;
import org.jamocha.rete.Template;
import org.jamocha.rete.exception.AssertException;
import org.jamocha.rete.exception.RetractException;

public class ModifyFunction
implements RuleFunction,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String MODIFY = "modify";
    protected Fact[] triggerFacts = null;

    public void setTriggerFacts(Fact[] facts) {
        this.triggerFacts = facts;
    }

    public int getReturnType() {
        return 12;
    }

    public ReturnVector executeFunction(Rete engine, Parameter[] params) {
        boolean exec = false;
        if (params != null && params.length >= 2 && params[0].isObjectBinding()) {
            BoundParam bp = (BoundParam)params[0];
            Deffact fact = (Deffact)bp.getFact();
            try {
                engine.retractFact(fact);
                Parameter[] sp = new SlotParam[params.length - 1];
                int idx = 0;
                while (idx < sp.length) {
                    Parameter p = params[idx + 1];
                    if (p instanceof SlotParam) {
                        sp[idx] = (SlotParam)p;
                    }
                    ++idx;
                }
                fact.updateSlots(engine, this.convertToSlots(sp, fact.getDeftemplate()));
                if (fact.hasBinding()) {
                    fact.resolveValues(engine, this.triggerFacts);
                    fact = fact.cloneFact();
                }
                engine.assertFact(fact);
                exec = true;
            }
            catch (RetractException e) {
                engine.writeMessage(e.getMessage());
            }
            catch (AssertException e) {
                engine.writeMessage(e.getMessage());
            }
        }
        DefaultReturnVector rv = new DefaultReturnVector();
        DefaultReturnValue rval = new DefaultReturnValue(20, new Boolean(exec));
        rv.addReturnValue(rval);
        return rv;
    }

    public String getName() {
        return MODIFY;
    }

    public Class[] getParameter() {
        return new Class[]{BoundParam.class, SlotParam[].class};
    }

    public BaseSlot[] convertToSlots(Parameter[] params, Template templ) {
        BaseSlot[] slts = new BaseSlot[params.length];
        int idx = 0;
        while (idx < params.length) {
            slts[idx] = ((SlotParam)params[idx]).getSlotValue();
            int col = templ.getColumnIndex(slts[idx].getName());
            if (col != -1) {
                slts[idx].setId(col);
            }
            ++idx;
        }
        return slts;
    }

    public String toPPString(Parameter[] params, int indents) {
        if (params != null && params.length > 0) {
            StringBuffer buf = new StringBuffer();
            buf.append("(modify ");
            buf.append("?" + ((BoundParam)params[0]).getVariableName() + " ");
            int idx = 1;
            while (idx < params.length) {
                SlotParam sp = (SlotParam)params[idx];
                Slot s = sp.getSlotValue();
                if (s.getValue() instanceof BoundParam) {
                    buf.append("(" + s.getName() + " ?" + ((BoundParam)s.getValue()).getVariableName() + ")");
                } else {
                    buf.append("(" + s.getName() + " " + s.getValue() + ")");
                }
                ++idx;
            }
            buf.append(" )");
            return buf.toString();
        }
        return "(modify [binding] [deffact])\nFunction description:\n\tAllows the user to modify template facts on the fact-list.";
    }
}

