/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete.functions;

import java.io.Serializable;
import org.jamocha.rete.DefaultReturnValue;
import org.jamocha.rete.DefaultReturnVector;
import org.jamocha.rete.Function;
import org.jamocha.rete.Parameter;
import org.jamocha.rete.Rete;
import org.jamocha.rete.ReturnVector;
import org.jamocha.rete.ValueParam;
import org.jamocha.rete.functions.UserDefinedFunctions;

public class LoadFunctionsFunction
implements Function,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String LOAD_FUNCTION = "load-function";
    protected UserDefinedFunctions userDefinedFunctions = null;

    public int getReturnType() {
        return 20;
    }

    public ReturnVector executeFunction(Rete engine, Parameter[] params) {
        boolean load = false;
        DefaultReturnVector ret = new DefaultReturnVector();
        if (params != null && params.length > 0) {
            int idx = 0;
            while (idx < params.length) {
                String func = params[idx].getStringValue();
                try {
                    Function f = engine.declareFunction(func);
                    this.userDefinedFunctions.addFunction(f);
                    load = true;
                }
                catch (ClassNotFoundException e) {
                    load = false;
                }
                ++idx;
            }
        }
        DefaultReturnValue rv = new DefaultReturnValue(20, new Boolean(load));
        ret.addReturnValue(rv);
        return ret;
    }

    public String getName() {
        return LOAD_FUNCTION;
    }

    public Class[] getParameter() {
        return new Class[]{ValueParam.class};
    }

    public String toPPString(Parameter[] params, int indents) {
        return "(load-function [classname])";
    }

    public UserDefinedFunctions getUserDefinedFunctions() {
        return this.userDefinedFunctions;
    }

    public void setUserDefinedFunctions(UserDefinedFunctions userDefinedFunctions) {
        this.userDefinedFunctions = userDefinedFunctions;
    }
}

