/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete.functions;

import java.io.Serializable;
import org.jamocha.rete.DefaultReturnValue;
import org.jamocha.rete.DefaultReturnVector;
import org.jamocha.rete.Function;
import org.jamocha.rete.Parameter;
import org.jamocha.rete.Rete;
import org.jamocha.rete.ReturnVector;
import org.jamocha.rete.ValueParam;

public class LoadFunctionGroupFunction
implements Function,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String LOAD_FGROUP = "load-function-group";

    public int getReturnType() {
        return 20;
    }

    public ReturnVector executeFunction(Rete engine, Parameter[] params) {
        boolean load = false;
        DefaultReturnVector ret = new DefaultReturnVector();
        if (params != null && params.length > 0) {
            int idx = 0;
            while (idx < params.length) {
                try {
                    String func = params[idx].getStringValue();
                    engine.declareFunctionGroup(func);
                    load = true;
                }
                catch (ClassNotFoundException e) {
                    engine.writeMessage(e.getMessage());
                    load = false;
                }
                ++idx;
            }
        }
        DefaultReturnValue rv = new DefaultReturnValue(20, new Boolean(load));
        ret.addReturnValue(rv);
        return ret;
    }

    public String getName() {
        return LOAD_FGROUP;
    }

    public Class[] getParameter() {
        return new Class[]{ValueParam.class};
    }

    public String toPPString(Parameter[] params, int indents) {
        return "(load-function-group [classname])";
    }
}

