/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete.functions;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import org.jamocha.rete.Constants;
import org.jamocha.rete.DefaultReturnVector;
import org.jamocha.rete.Function;
import org.jamocha.rete.FunctionGroup;
import org.jamocha.rete.Parameter;
import org.jamocha.rete.Rete;
import org.jamocha.rete.ReturnVector;

public class ListFunctionsFunction
implements Function,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String LIST_FUNCTIONS = "list-deffunctions";
    public static final String FUNCTIONS = "functions";

    public int getReturnType() {
        return 12;
    }

    public ReturnVector executeFunction(Rete engine, Parameter[] params) {
        List fgroups = engine.getFunctionGroups();
        Iterator itr = fgroups.iterator();
        int counter = 0;
        while (itr.hasNext()) {
            FunctionGroup fg = (FunctionGroup)itr.next();
            engine.writeMessage("++++ " + fg.getName() + " ++++" + Constants.LINEBREAK, "t");
            for (Function f : fg.listFunctions()) {
                engine.writeMessage("  " + f.getName() + Constants.LINEBREAK, "t");
                ++counter;
            }
        }
        engine.writeMessage(String.valueOf(counter) + " functions" + Constants.LINEBREAK, "t");
        DefaultReturnVector ret = new DefaultReturnVector();
        return ret;
    }

    public String getName() {
        return LIST_FUNCTIONS;
    }

    public Class[] getParameter() {
        return new Class[0];
    }

    public String toPPString(Parameter[] params, int indents) {
        if (indents > 0) {
            StringBuffer buf = new StringBuffer();
            int idx = 0;
            while (idx < indents) {
                buf.append(" ");
                ++idx;
            }
            buf.append("(list-deffunctions)");
            return buf.toString();
        }
        return "(list-deffunctions)";
    }
}

