/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete.functions;

import java.io.File;
import java.io.Serializable;
import org.jamocha.rete.Constants;
import org.jamocha.rete.DefaultReturnVector;
import org.jamocha.rete.Function;
import org.jamocha.rete.Parameter;
import org.jamocha.rete.Rete;
import org.jamocha.rete.ReturnVector;

public class ListDirectoryFunction
implements Function,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String LIST_DIR = "list-dir";

    public int getReturnType() {
        return 12;
    }

    public ReturnVector executeFunction(Rete engine, Parameter[] params) {
        File dir;
        if (params != null && params.length > 0 && (dir = new File(params[0].getStringValue())).isDirectory()) {
            File[] files = dir.listFiles();
            int idx = 0;
            while (idx < files.length) {
                if (files[idx].isDirectory()) {
                    engine.writeMessage("d " + files[idx] + Constants.LINEBREAK);
                } else {
                    engine.writeMessage("- " + files[idx] + Constants.LINEBREAK);
                }
                ++idx;
            }
            engine.writeMessage(String.valueOf(files.length) + " files in the directory" + Constants.LINEBREAK, "t");
        }
        DefaultReturnVector ret = new DefaultReturnVector();
        return ret;
    }

    public String getName() {
        return LIST_DIR;
    }

    public Class[] getParameter() {
        return new Class[0];
    }

    public String toPPString(Parameter[] params, int indents) {
        if (indents > 0) {
            StringBuffer buf = new StringBuffer();
            int idx = 0;
            while (idx < indents) {
                buf.append(" ");
                ++idx;
            }
            buf.append("(list-dir)");
            return buf.toString();
        }
        return "(list-dir)";
    }
}

