/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete.functions;

import java.io.Serializable;
import org.jamocha.rete.AbstractParam;
import org.jamocha.rete.BoundParam;
import org.jamocha.rete.DefaultReturnValue;
import org.jamocha.rete.DefaultReturnVector;
import org.jamocha.rete.Function;
import org.jamocha.rete.FunctionParam2;
import org.jamocha.rete.Parameter;
import org.jamocha.rete.Rete;
import org.jamocha.rete.ReturnVector;
import org.jamocha.rete.ValueParam;

public class IfFunction
implements Function,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String IF = "if";

    public int getReturnType() {
        return 9;
    }

    public ReturnVector executeFunction(Rete engine, Parameter[] params) {
        Object result = null;
        if (params != null && params.length >= 3) {
            AbstractParam n;
            boolean conditionValue = false;
            if (params[0] instanceof ValueParam) {
                n = (ValueParam)params[0];
                conditionValue = n.getBooleanValue();
            } else if (params[0] instanceof BoundParam) {
                BoundParam bp = (BoundParam)params[0];
                conditionValue = (Boolean)engine.getBinding(bp.getVariableName());
            } else if (params[0] instanceof FunctionParam2) {
                n = (FunctionParam2)params[0];
                ((FunctionParam2)n).setEngine(engine);
                ((FunctionParam2)n).lookUpFunction();
                ReturnVector rval = (ReturnVector)((FunctionParam2)n).getValue();
                conditionValue = rval.firstReturnValue().getBooleanValue();
            }
            if (params[1] instanceof ValueParam && "then".equals(params[1].getStringValue())) {
                boolean elseExpressions = false;
                int i = 2;
                while (i < params.length) {
                    if (params[i] instanceof ValueParam && "else".equals(params[i].getStringValue())) {
                        elseExpressions = true;
                    } else if (conditionValue && !elseExpressions || !conditionValue && elseExpressions) {
                        AbstractParam n2;
                        if (params[i] instanceof ValueParam) {
                            n2 = (ValueParam)params[i];
                            result = ((ValueParam)n2).getValue();
                        } else if (params[i] instanceof BoundParam) {
                            BoundParam bp = (BoundParam)params[i];
                            result = engine.getBinding(bp.getVariableName());
                        } else if (params[i] instanceof FunctionParam2) {
                            n2 = (FunctionParam2)params[i];
                            ((FunctionParam2)n2).setEngine(engine);
                            ((FunctionParam2)n2).lookUpFunction();
                            ReturnVector rval = (ReturnVector)((FunctionParam2)n2).getValue();
                            if (rval.size() > 0) {
                                result = rval.firstReturnValue().getValue();
                            }
                        }
                    }
                    ++i;
                }
            }
        }
        DefaultReturnVector ret = new DefaultReturnVector();
        DefaultReturnValue rv = new DefaultReturnValue(9, result);
        ret.addReturnValue(rv);
        return ret;
    }

    public String getName() {
        return IF;
    }

    public Class[] getParameter() {
        return new Class[]{ValueParam[].class};
    }

    public String toPPString(Parameter[] params, int indents) {
        if (params != null && params.length >= 0) {
            StringBuffer buf = new StringBuffer();
            buf.append("(if");
            int idx = 0;
            if (params[idx] instanceof BoundParam) {
                BoundParam bp = (BoundParam)params[idx];
                buf.append(" ?" + bp.getVariableName());
            } else if (params[idx] instanceof ValueParam) {
                buf.append(" " + params[idx].getStringValue());
            } else {
                buf.append(" " + params[idx].getStringValue());
            }
            buf.append(")");
            return buf.toString();
        }
        return "(if <boolean expression> then <expression>+ [else <expression>+])\nFunction description:\n\tExecutes the expressions after then if the boolean expressions evaluates to true, otherwise it executes the expressions after the optional else.";
    }
}

