/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete.functions;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import org.jamocha.rete.Constants;
import org.jamocha.rete.DefaultReturnVector;
import org.jamocha.rete.Fact;
import org.jamocha.rete.Function;
import org.jamocha.rete.Parameter;
import org.jamocha.rete.Rete;
import org.jamocha.rete.ReturnVector;
import org.jamocha.rete.util.FactUtils;

public class FactsFunction
implements Function,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String FACTS = "facts";

    public int getReturnType() {
        return 12;
    }

    public ReturnVector executeFunction(Rete engine, Parameter[] params) {
        boolean filter = false;
        HashMap objects = new HashMap();
        int count = 0;
        if (params != null && params.length > 0) {
            filter = true;
            int idx = 0;
            while (idx < params.length) {
                objects.put(params[idx].getValue(), null);
                ++idx;
            }
        }
        List facts = engine.getAllFacts();
        Object[] sorted = FactUtils.sortFacts(facts);
        int idx = 0;
        while (idx < sorted.length) {
            Fact ft = (Fact)sorted[idx];
            if (filter) {
                if (objects.containsKey(ft.getDeftemplate().getName())) {
                    engine.writeMessage(String.valueOf(ft.toFactString()) + Constants.LINEBREAK);
                }
                ++count;
            } else {
                engine.writeMessage(String.valueOf(ft.toFactString()) + Constants.LINEBREAK);
                ++count;
            }
            ++idx;
        }
        engine.writeMessage("for a total of " + count + Constants.LINEBREAK, Constants.DEFAULT_OUTPUT);
        return new DefaultReturnVector();
    }

    public String getName() {
        return FACTS;
    }

    public Class[] getParameter() {
        return new Class[0];
    }

    public String toPPString(Parameter[] params, int indents) {
        return "(facts)\nFunction description:\n\tPrints all facts except the initial facts.";
    }
}

