/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete.functions;

import java.io.Serializable;
import java.math.BigDecimal;
import org.jamocha.rete.Constants;
import org.jamocha.rete.DefaultReturnVector;
import org.jamocha.rete.Fact;
import org.jamocha.rete.Function;
import org.jamocha.rete.Parameter;
import org.jamocha.rete.Rete;
import org.jamocha.rete.ReturnVector;

public class FactIdFunction
implements Function,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String FACT_ID = "fact-id";

    public int getReturnType() {
        return 12;
    }

    public ReturnVector executeFunction(Rete engine, Parameter[] params) {
        if (params != null && params.length > 0) {
            int idx = 0;
            while (idx < params.length) {
                BigDecimal id = (BigDecimal)params[idx].getValue(engine, 16);
                Fact f = engine.getFactById(id.longValue());
                if (f != null) {
                    engine.writeMessage(String.valueOf(f.toFactString()) + Constants.LINEBREAK);
                }
                ++idx;
            }
        }
        return new DefaultReturnVector();
    }

    public String getName() {
        return FACT_ID;
    }

    public Class[] getParameter() {
        return new Class[]{Long.TYPE};
    }

    public String toPPString(Parameter[] params, int indents) {
        return "(fact-id)\nFunction description:\n\tPrints the string for the fact with the given id.";
    }
}

