/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete.functions;

import java.io.Serializable;
import java.io.StringReader;
import org.jamocha.messagerouter.CLIPSInterpreter;
import org.jamocha.parser.clips.CLIPSParser;
import org.jamocha.parser.clips.ParseException;
import org.jamocha.rete.BoundParam;
import org.jamocha.rete.Function;
import org.jamocha.rete.Parameter;
import org.jamocha.rete.Rete;
import org.jamocha.rete.ReturnVector;
import org.jamocha.rete.ValueParam;

public class EvalFunction
implements Function,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String EVAL = "eval";

    public int getReturnType() {
        return 9;
    }

    public ReturnVector executeFunction(Rete engine, Parameter[] params) {
        String command;
        ReturnVector result = null;
        if (params != null && params.length > 0 && (command = (String)params[0].getValue(engine, 11)) != null) {
            result = this.eval(engine, command);
        }
        return result;
    }

    public ReturnVector eval(Rete engine, String command) {
        ReturnVector result = null;
        try {
            CLIPSParser parser = new CLIPSParser(engine, new StringReader(command));
            CLIPSInterpreter interpreter = new CLIPSInterpreter(engine);
            Object expr = null;
            while ((expr = parser.basicExpr()) != null) {
                result = interpreter.executeCommand(expr);
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return result;
    }

    public String getName() {
        return EVAL;
    }

    public Class[] getParameter() {
        return new Class[]{ValueParam.class};
    }

    public String toPPString(Parameter[] params, int indents) {
        if (params != null && params.length > 0) {
            StringBuffer buf = new StringBuffer();
            buf.append("(eval");
            int idx = 0;
            while (idx < params.length) {
                if (params[idx] instanceof BoundParam) {
                    BoundParam bp = (BoundParam)params[idx];
                    buf.append(" ?" + bp.getVariableName());
                } else if (params[idx] instanceof ValueParam) {
                    buf.append(" \"" + params[idx].getStringValue() + "\"");
                }
                ++idx;
            }
            buf.append(")");
            return buf.toString();
        }
        return "(eval <string expressions>)\nCommand description:\n\tEvaluates the content of a string.";
    }
}

