/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete.functions;

import java.io.Serializable;
import org.jamocha.rete.AbstractParam;
import org.jamocha.rete.BoundParam;
import org.jamocha.rete.DefaultReturnValue;
import org.jamocha.rete.DefaultReturnVector;
import org.jamocha.rete.Function;
import org.jamocha.rete.FunctionParam2;
import org.jamocha.rete.Parameter;
import org.jamocha.rete.Rete;
import org.jamocha.rete.ReturnVector;
import org.jamocha.rete.ValueParam;

public class EqFunction
implements Function,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String EQUAL = "eq";

    public int getReturnType() {
        return 20;
    }

    public ReturnVector executeFunction(Rete engine, Parameter[] params) {
        DefaultReturnVector ret = new DefaultReturnVector();
        boolean eq = false;
        if (params != null && params.length > 1) {
            AbstractParam n;
            Object first = null;
            if (params[0] instanceof ValueParam) {
                n = (ValueParam)params[0];
                first = ((ValueParam)n).getValue();
            } else if (params[0] instanceof BoundParam) {
                BoundParam bp = (BoundParam)params[0];
                first = bp.getValue();
                if (first == null) {
                    first = engine.getBinding(bp.getVariableName());
                }
            } else if (params[0] instanceof FunctionParam2) {
                n = (FunctionParam2)params[0];
                ((FunctionParam2)n).setEngine(engine);
                ((FunctionParam2)n).lookUpFunction();
                ReturnVector rval = (ReturnVector)((FunctionParam2)n).getValue();
                first = rval.firstReturnValue().getValue();
            }
            boolean eval = true;
            int idx = 1;
            while (idx < params.length) {
                AbstractParam n2;
                Object right = null;
                if (params[idx] instanceof ValueParam) {
                    n2 = (ValueParam)params[idx];
                    right = ((ValueParam)n2).getValue();
                } else if (params[idx] instanceof BoundParam) {
                    BoundParam bp = (BoundParam)params[idx];
                    right = bp.getValue();
                    if (right == null) {
                        right = engine.getBinding(bp.getVariableName());
                    }
                } else if (params[idx] instanceof FunctionParam2) {
                    n2 = (FunctionParam2)params[idx];
                    ((FunctionParam2)n2).setEngine(engine);
                    ((FunctionParam2)n2).lookUpFunction();
                    ReturnVector rval = (ReturnVector)((FunctionParam2)n2).getValue();
                    right = rval.firstReturnValue().getValue();
                }
                if (first == null && right != null) {
                    eval = false;
                    break;
                }
                if (first != null && !first.equals(right)) {
                    eval = false;
                    break;
                }
                ++idx;
            }
            eq = eval;
        }
        DefaultReturnValue rv = new DefaultReturnValue(20, new Boolean(eq));
        ret.addReturnValue(rv);
        return ret;
    }

    public String getName() {
        return EQUAL;
    }

    public Class[] getParameter() {
        return new Class[]{ValueParam[].class};
    }

    public String toPPString(Parameter[] params, int indents) {
        return "(eq (<literal> | <binding>)+)\nFunction description:\n\tCompares a literal value against one or morebindings. \n\tIf all of the bindings are equal to the constant value,\n\tthe function returns true.";
    }
}

