/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete.functions;

import java.io.Serializable;
import org.jamocha.rete.BoundParam;
import org.jamocha.rete.Constants;
import org.jamocha.rete.DefaultReturnValue;
import org.jamocha.rete.DefaultReturnVector;
import org.jamocha.rete.Function;
import org.jamocha.rete.Parameter;
import org.jamocha.rete.Rete;
import org.jamocha.rete.ReturnVector;
import org.jamocha.rete.ShellBoundParam;

public class EchoFunction
implements Function,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String ECHO = "echo";

    public int getReturnType() {
        return 11;
    }

    public ReturnVector executeFunction(Rete engine, Parameter[] params) {
        StringBuffer buf = new StringBuffer();
        int idx = 0;
        while (idx < params.length) {
            if (params[idx] instanceof ShellBoundParam) {
                ShellBoundParam bp = (ShellBoundParam)params[idx];
                bp.resolveBinding(engine);
                buf.append(String.valueOf(bp.getStringValue()) + Constants.LINEBREAK);
            }
            ++idx;
        }
        DefaultReturnVector ret = new DefaultReturnVector();
        DefaultReturnValue rv = new DefaultReturnValue(11, buf.toString());
        ret.addReturnValue(rv);
        return ret;
    }

    public String getName() {
        return ECHO;
    }

    public Class[] getParameter() {
        return new Class[]{ShellBoundParam[].class};
    }

    public String toPPString(Parameter[] params, int indents) {
        if (params != null && params.length > 0) {
            StringBuffer buf = new StringBuffer();
            buf.append("(echo");
            int idx = 0;
            while (idx < params.length) {
                if (params[idx] instanceof BoundParam) {
                    BoundParam bp = (BoundParam)params[idx];
                    buf.append(" ?" + bp.getVariableName());
                } else {
                    buf.append(" \"" + params[idx].getStringValue() + "\"");
                }
                ++idx;
            }
            buf.append(")");
            return buf.toString();
        }
        return "(echo [parameter])";
    }
}

